<?php
  session_start();
  require("config.php");
  // o usuário está logado?
  if(!isset($_SESSION["id_usuario_logado"])){
    header("Location: login.php");
    exit;
  }
  
  $id_unico_atendimento = time();
  
  // rotina para cadastrar o atendimento
  if(isset($_POST["cadastrar_atendimento"])){
	 $id_usuario_logado = $_SESSION["id_usuario_logado"];
     $id_cliente_fornecedor = tratar_entrada(utf8_decode(trim($_POST["id_cliente_fornecedor"])));
	 $id_unico_atendimento = tratar_entrada(utf8_decode(trim($_POST["id_unico_atendimento"])));
     $texto_atendimento = tratar_entrada(utf8_decode(trim($_POST["texto_atendimento"])));
	 $status = tratar_entrada(utf8_decode(trim($_POST["status"])));
	 
	 //  id, id_cliente_fornecedor, texto, resolvido, data_cadastro, usuario_cadastro
	 $result = mysqli_query($conexao, "INSERT into atendimentos values (null, '$id_cliente_fornecedor', '$texto_atendimento',
	    '$status', NOW(), '$id_usuario_logado', '$id_unico_atendimento')");
	 
    if($result){
	  $id_inserido = mysqli_insert_id($conexao);
	  
	  // houve upload de anexos?
      $result_anexos = mysqli_query($conexao, "UPDATE anexos_atendimentos SET id_pai = '$id_inserido' 
        WHERE id_unico = '$id_unico_atendimento'");
      // fim houve upload de anexos
	  
	   // vamos registrar esse log
      $ip = getUserIpAddr();
      $id_usuario_logado = $_SESSION["id_usuario_logado"];
      $usuario_logado = $_SESSION["usuario_logado"];
      $texto_log = 'O usuario ' . $usuario_logado . ' cadastrou um novo atendimento.';
      $result_2 = mysqli_query($conexao, "INSERT into logs values (null, '$id_usuario_logado', '$texto_log', 
        NOW(), '$usuario_logado', '$ip')");
      // fim registrar o log 
    }
    else{
	  $_SESSION["erro_banco_dados"] = "Houve um erro no cadastro de atendimentos.<br><br>Erro: " . mysqli_error($conexao);
      header("Location: erro_banco_dados.php");
      exit;  
    }
  }
  // fim cadastrar o atendimento
  
  // rotina para atualizar o atendimento
  if(isset($_POST["atualizar_atendimento"])){
	 $id_usuario_logado = $_SESSION["id_usuario_logado"];
     $id_atendimento = tratar_entrada(utf8_decode(trim($_POST["id_atendimento"])));
     $texto_atendimento = tratar_entrada(utf8_decode(trim($_POST["texto_atendimento"])));
	 $status = tratar_entrada(utf8_decode(trim($_POST["status"])));
	 
	 //  id, id_cliente_fornecedor, texto, resolvido, data_cadastro, usuario_cadastro
	 $result = mysqli_query($conexao, "UPDATE atendimentos SET texto = '$texto_atendimento',
	    resolvido = '$status' WHERE id = '$id_atendimento'");
	 
    if($result){
	   // vamos registrar esse log
      $ip = getUserIpAddr();
      $id_usuario_logado = $_SESSION["id_usuario_logado"];
      $usuario_logado = $_SESSION["usuario_logado"];
      $texto_log = 'O usuario ' . $usuario_logado . ' cadastrou um novo atendimento.';
      $result_2 = mysqli_query($conexao, "INSERT into logs values (null, '$id_usuario_logado', '$texto_log', 
        NOW(), '$usuario_logado', '$ip')");
      // fim registrar o log 
    }
    else{
	  $_SESSION["erro_banco_dados"] = "Houve um erro no cadastro de atendimentos.<br><br>Erro: " . mysqli_error($conexao);
      header("Location: erro_banco_dados.php");
      exit;  
    }
  }
  // fim atualizar o atendimento
  
  // id do cliente ou fornecedor a ser visualizado
  $id_cliente_fornecedor = (int)(trim($_GET["cliente_fornecedor"]));
  $tipo = (int)(trim($_GET["tipo"]));
  
  $result = mysqli_query($conexao, "SELECT id, fantasia, razao_social, cpf_cnpj, email, telefone, responsavel, telefone_responsavel,
    endereco, setor, cidade, estado, cep, info, foto, DATE_FORMAT(data_cadastro, '%d/%m/%Y - %H:%i') as data_cadastro, tipo,  
    usuario_cadastro from clientes_fornecedores WHERE id = '$id_cliente_fornecedor'");
  if($result){
	while($detalhes = mysqli_fetch_array($result)){
	   $fantasia = utf8_encode($detalhes["fantasia"]);
	   $foto = $detalhes["foto"];
	   $razao_social = utf8_encode($detalhes["razao_social"]);
	   $telefone = utf8_encode($detalhes["telefone"]);
	   $cpf_cnpj = $detalhes["cpf_cnpj"];
	   $email = utf8_encode($detalhes["email"]);
	   $responsavel = utf8_encode($detalhes["responsavel"]);
	   $telefone_responsavel = utf8_encode($detalhes["telefone_responsavel"]);
	   $endereco = utf8_encode($detalhes["endereco"]);
	   $setor = utf8_encode($detalhes["setor"]);
	   $cidade = utf8_encode($detalhes["cidade"]);
	   $estado = utf8_encode($detalhes["estado"]);
	   $cep = utf8_encode($detalhes["cep"]);
	   $ambos = utf8_encode($detalhes["tipo"]);
	   $info = utf8_encode($detalhes["info"]);
	   $data_cadastro = $detalhes["data_cadastro"];
	   $usuario_cadastro = $detalhes["usuario_cadastro"];
	
	   if(file_exists($diretorio_fotos_clientes_fornecedores . '/' . $foto . '.png')){
		  $foto = $url_fotos_clientes_fornecedores . '/' . $foto . '.png';
	   }
	   else{
		  $foto = $url_base_aplicacao . '/imagens/cliente_fornecedor_sem_foto.jpg'; 
	    }
	}
  }
  
  // vamos registrar esse log
  $ip = getUserIpAddr();
  $id_usuario_logado = $_SESSION["id_usuario_logado"];
  $usuario_logado = $_SESSION["usuario_logado"];
  $texto_log = 'O usuario ' . $usuario_logado . ' acessou o ' . (($tipo == "1") ? 'cliente ' : 'fornecedor ') . $fantasia . '.';
  $result_2 = mysqli_query($conexao, "INSERT into logs values (null, '$id_usuario_logado', '$texto_log', 
    NOW(), '$usuario_logado', '$ip')");
  // fim registrar o log
  
  
  $foto_cliente_fornecedor = time();
?>
<!DOCTYPE html>
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-2" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge" />
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
  <meta name="description" content="" />
  <meta name="author" content="" />
  <title><?= $titulo_aplicacao ?> - <?= ($tipo == "1") ? 'Cliente' : 'Fornecedor' ?></title>
  <link rel="stylesheet" href="bootstrap-icons-1.5.0/font/bootstrap-icons.css" />
  <link rel="stylesheet" href="css/classic.css">
  <link rel="stylesheet" href="css/classic.date.css">
  <link rel="stylesheet" type="text/css" href="DataTables-1.10.25/css/jquery.dataTables.css"/>
  <link href="css/styles.css?<?= date('Y-m-d_H:i:s'); ?>" rel="stylesheet" />
  
  <script src="js/jquery.min.js"></script>
  <link href="css/cropper.css" rel="stylesheet"/>
  <script src="js/cropper.js"></script>
  
  <script src="font-awesome/js/all.min.js" crossorigin="anonymous"></script>
  <script type="text/javascript" src="DataTables-1.10.25/js/jquery.dataTables.js?<?= date('Y-m-d_H:i:s'); ?>"></script>
  
  <style type="text/css">
    a{text-decoration:none} 
    .has-search .form-control {
    padding-left: 2.375rem;
    }

   .has-search .form-control-feedback {
    position: absolute;
    z-index: 2;
    display: block;
    width: 2.375rem;
    height: 2.375rem;
    line-height: 2.375rem;
    text-align: center;
    pointer-events: none;
    color: #aaa;
}

.blue-text {
    color: #00BCD4
}

.form-control-label {
    margin-bottom: 0
}

input,
textarea,
button {
    padding: 8px 15px;
    border-radius: 5px !important;
    margin: 5px 0px;
    box-sizing: border-box;
    border: 1px solid #ccc;
    font-size: 18px !important;
    font-weight: 300
}

input:focus,
textarea:focus {
    -moz-box-shadow: none !important;
    -webkit-box-shadow: none !important;
    box-shadow: none !important;
    border: 1px solid #00BCD4;
    outline-width: 0;
    font-weight: 400
}

.btn-block {
    text-transform: uppercase;
    font-size: 15px !important;
    font-weight: 400;
    height: 43px;
    cursor: pointer
}

.btn-block:hover {
    color: #fff !important
}

button:focus {
    -moz-box-shadow: none !important;
    -webkit-box-shadow: none !important;
    box-shadow: none !important;
    outline-width: 0
}

.image_area {
		  position: relative;
		}

		img {
		  	display: block;
		  	max-width: 100%;
		}

		.preview {
  			overflow: hidden;
  			width: 160px; 
  			height: 160px;
  			margin: 10px;
  			border: 1px solid red;
		}

		.modal-lg{
  			max-width: 1000px !important;
		}

		.overlay {
		  position: absolute;
		  bottom: 10px;
		  left: 0;
		  right: 0;
		  background-color: rgba(255, 255, 255, 0.5);
		  overflow: hidden;
		  height: 0;
		  transition: .5s ease;
		  width: 100%;
		}

		.image_area:hover .overlay {
		  height: 50%;
		  cursor: pointer;
		}

		.text {
		  color: #333;
		  font-size: 20px;
		  position: absolute;
		  top: 50%;
		  left: 50%;
		  -webkit-transform: translate(-50%, -50%);
		  -ms-transform: translate(-50%, -50%);
		  transform: translate(-50%, -50%);
		  text-align: center;
		}

  </style>
</head>

<body class="sb-nav-fixed">

<?php require("cima.php"); ?>

<div id="layoutSidenav">
            
            <?php require("menu_lado.php"); ?>
            
            <div id="layoutSidenav_content">
                <main>
                    <div class="container-fluid px-4">
                        
                        <h1 class="mt-4"><i class="far fa-address-card"></i> <?= $fantasia ?></h1>
                        
                        <ol class="breadcrumb mb-4">
                            <li class="breadcrumb-item"><a href="index.php">P&aacute;gina Inicial</a></li>
                            <li class="breadcrumb-item active"><?= ($tipo == "1") ? 'Cliente' : 'Fornecedor' ?></li>
                        </ol>
                        
                        <nav>
                           <div class="nav nav-tabs" id="nav-tab" role="tablist">
                              <a class="nav-link <?= (isset($_GET["aba_clientes"]) ? 'active' : '') ?>" id="nav-cliente-fornecedor-tab" data-bs-toggle="tab" href="#nav-cliente-fornecedor" 
                              role="tab" aria-controls="nav-cliente-fornecedor" aria-selected="true">Detalhes do Cliente</a>
                              
                              <a class="nav-link <?= (isset($_GET["aba_recebimentos"]) ? 'active' : '') ?>" id="nav-recebimentos-tab" data-bs-toggle="tab" href="#nav-recebimentos" role="tab" 
                              aria-controls="nav-recebimentos" aria-selected="false">Recebimentos</a>
                              
                              <a class="nav-link <?= (isset($_GET["aba_pagamentos"]) ? 'active' : '') ?>" id="nav-pagamentos-tab" data-bs-toggle="tab" href="#nav-pagamentos" role="tab" 
                              aria-controls="nav-pagamentos" aria-selected="false">Pagamentos</a>
                              
                              <a class="nav-link <?= (isset($_GET["aba_receber"]) ? 'active' : '') ?>" id="nav-receber-tab" data-bs-toggle="tab" href="#nav-receber" role="tab" 
                              aria-controls="nav-receber" aria-selected="false">A Receber</a>
                              
                              <a class="nav-link <?= (isset($_GET["aba_pagar"]) ? 'active' : '') ?>" id="nav-pagar-tab" data-bs-toggle="tab" href="#nav-pagar" role="tab" 
                              aria-controls="nav-pagar" aria-selected="false">A Pagar</a>
                              
                              <a class="nav-link <?= (isset($_GET["aba_atendimentos"]) ? 'active' : '') ?>" id="nav-atendimentos-tab" data-bs-toggle="tab" href="#nav-atendimentos" role="tab" 
                              aria-controls="nav-atendimentos" aria-selected="false">Hist&oacute;rico de Atendimentos</a>
                           </div>
                        </nav>
                        
                        <div class="tab-content" id="nav-tabContent">
                           
                           <div class="tab-pane fade <?= (isset($_GET["aba_clientes"]) ? 'active show' : '') ?>" id="nav-cliente-fornecedor" role="tabpanel" aria-labelledby="nav-cliente-fornecedor-tab">
                              <!-- INCLUI OS DADOS DO CLIENTE/FORNECEDOR AQUI //-->
                              <?php require("includes/detalhes_cliente_fornecedor.php"); ?>
                           </div>
                        
                           <div class="tab-pane fade <?= (isset($_GET["aba_recebimentos"]) ? 'active show' : '') ?>" id="nav-recebimentos" role="tabpanel" aria-labelledby="nav-recebimentos-tab">
                              <!-- INCLUI OS RECEBIMENTOS //-->
                              <?php require("includes/recebimentos.php"); ?>
                           </div>
                        
                           <div class="tab-pane fade <?= (isset($_GET["aba_pagamentos"]) ? 'active show' : '') ?>" id="nav-pagamentos" role="tabpanel" aria-labelledby="nav-pagamentos-tab">
                              <!-- INCLUI OS PAGAMENTOS //-->
                              <?php require("includes/pagamentos.php"); ?>
                           </div> 
                        
                           <div class="tab-pane fade <?= (isset($_GET["aba_receber"]) ? 'active show' : '') ?>" id="nav-receber" role="tabpanel" aria-labelledby="nav-receber-tab">
                              <!-- INCLUI AS CONTAS A RECEBER //-->
                              <?php require("includes/receber.php"); ?>
                           </div>
                        
                           <div class="tab-pane fade <?= (isset($_GET["aba_pagar"]) ? 'active show' : '') ?>" id="nav-pagar" role="tabpanel" aria-labelledby="nav-pagar-tab">
                              <!-- INCLUI AS CONTAS A PAGAR //-->
                              <?php require("includes/pagar.php"); ?>
                           </div>
                        
                           <div class="tab-pane fade <?= (isset($_GET["aba_atendimentos"]) ? 'active show' : '') ?>" id="nav-atendimentos" role="tabpanel" aria-labelledby="nav-atendimentos-tab">
                              <!-- INCLUI OS ATENDIMENTOS //-->
                              <?php require("includes/atendimentos.php"); ?>
                           </div>
                        
                        </div> 
                        
                    </div>
                </main>
                
                <?php require("rodape.php"); ?>
                
            </div>
        
        <div id="janela_excluir_cliente_fornecedor" class="modal fade" role="dialog" style="width:100%">
    <div class="modal-dialog" style="width: 60%;">
        <div class="modal-content" >
            <div class="modal-header">Excluir</div>
            <div class="modal-body"><span id="msg_excluir"></span></div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" onclick="confirmar_exclusao()">Confirmar</button>
                <button type="button" class="btn btn-secondary" onclick="fechar_exclusao()" data-dismiss="modal">Cancelar</button>
            </div>
        </div>
    </div>
    </div>
        
        <div id="janela_excluir_atendimento" class="modal fade" role="dialog" style="width:100%">
    <div class="modal-dialog" style="width: 60%;">
        <div class="modal-content" >
            <div class="modal-header">Excluir</div>
            <div class="modal-body"><span id="msg_excluir2"></span></div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" onclick="confirmar_exclusao_atendimento()">Confirmar</button>
                <button type="button" class="btn btn-secondary" onclick="fechar_exclusao_atendimento()" data-dismiss="modal">Cancelar</button>
            </div>
        </div>
    </div>
    </div>
        
        <div id="janela_excluir_anexo" class="modal fade" role="dialog" style="width:100%">
    <div class="modal-dialog" style="width: 60%;">
        <div class="modal-content" >
            <div class="modal-header">Excluir</div>
            <div class="modal-body"><span id="msg_excluir3"></span></div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" onclick="confirmar_exclusao_anexo()">Confirmar</button>
                <button type="button" class="btn btn-secondary" onclick="fechar_exclusao_anexo()" data-dismiss="modal">Cancelar</button>
            </div>
        </div>
    </div>
    </div>
        
        <div class="modal fade" id="modal" tabindex="-1" role="dialog" aria-labelledby="modalLabel" aria-hidden="true">
						<div class="modal-dialog modal-lg" role="document">
							<div class="modal-content">
								<div class="modal-header">
									<h5 class="modal-title">Recorte a imagem antes de salvar</h5>
									<button type="button" onclick="fecharCrop()" class="close" data-dismiss="modal" aria-label="Fechar">
										<span aria-hidden="true">×</span>
									</button>
								</div>
								<div class="modal-body">
									<div class="img-container">
										<div class="row">
											<div class="col-md-8">
												<img src="" id="sample_image" />
											</div>
											<div class="col-md-4">
												<div class="preview"></div>
											</div>
										</div>
									</div>
								</div>
								<div class="modal-footer">
									<button type="button" id="crop" class="btn btn-primary">Recortar e Salvar</button>
									<button type="button" onclick="fecharCrop()" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
								</div>
							</div>
						</div>
					</div>
  				</div>
        
        
        </div>
        <script src="bootstrap-5.0.2/js/bootstrap.bundle.min.js" crossorigin="anonymous"></script>
        <script src="js/scripts.js"></script>
        <script src="js/jquery.mask.min.js"></script>
    
    <script type="text/javascript">
	   var anexos_novo_atendimento = new Map();
	   var anexos_atualizar_atendimento = new Map();
	   
	   $(document).ready(function(){
	     // trata a formata�ao dos campos
	     $('#valor_pagamento').mask('000.000.000.000.000,00', {reverse: true});
		 $('#acrescimo_pagamento').mask('000.000.000.000.000,00', {reverse: true});
		 $('#abatimento_pagamento').mask('000.000.000.000.000,00', {reverse: true});
	     // fim formata�ao dos campos
	   });
	   
	   function atualizar_valor_total_pagamento(){
		  var acrescimos = $('#acrescimo_pagamento').val();
		  var descontos = $('#abatimento_pagamento').val();
		  var valor = $('#valor_pagamento').val();
		  
		  if(acrescimos.trim() == ""){
			return;  
		  }
		  if(valor.trim() == ""){
			return;  
		  }
		  if(descontos.trim() == ""){
			return;  
		  }
		  
		  valor = valor.replace(".", "");
		  valor = valor.replace(",", ".");
		  acrescimos = acrescimos.replace(".", "");
		  acrescimos = acrescimos.replace(",", ".");
		  descontos = descontos.replace(".", "");
		  descontos = descontos.replace(",", ".");
		  var valor_total = parseFloat(valor) + parseFloat(acrescimos) - parseFloat(descontos);
		  $('#total_pagamento').val(valor_total.toLocaleString('pt-br', {minimumFractionDigits: 2}));	
		}
		
		<?php if(isset($_GET["visualizar_atendimento"])){ ?>
		
		function exibir_lista_anexos_atualizar_atendimento(){
	      var docs_atualizar_atendimento = document.getElementById("docs_atualizar_atendimento");
	      docs_atualizar_atendimento.innerHTML = "";
	      for (let [chave, valor] of anexos_atualizar_atendimento){
            docs_atualizar_atendimento.innerHTML = docs_atualizar_atendimento.innerHTML + '<div style="border-bottom: 1px solid #eceff1; padding-top: 5px; padding-bottom: 10px"><a target="_blank" href="<?= $url_documentos_atendimentos ?>/' + valor + '">' + valor + '</a> <a title="Clique para excluir" href="javascript:excluir_anexo(\'ATUALIZAR\', \'' + chave + '\', \'' + valor + '\')"><img style="display: inline" border="0" width="25px" src="imagens/excluir.gif"/></a></div>';
          }
        }
		
		$(document).ready(function(){
	     // trata a formata�ao dos campos
	     $('#valor_pagamento_visualizar').mask('000.000.000.000.000,00', {reverse: true});
		 $('#acrescimo_pagamento_visualizar').mask('000.000.000.000.000,00', {reverse: true});
		 $('#abatimento_pagamento_visualizar').mask('000.000.000.000.000,00', {reverse: true});
	     // fim formata�ao dos campos
	   });
	  
	   <?php
	     if(isset($_GET["visualizar_atendimento"])){
		   $id_atendimento_temp = (int)($_GET["visualizar_atendimento"]);
		   
		   $result = mysqli_query($conexao, "select id, arquivo from anexos_atendimentos WHERE 
		     id_pai = '$id_atendimento_temp' order by id asc");
	       while($detalhes = mysqli_fetch_array($result)){
             $id_anexo = utf8_encode($detalhes["id"]);
	         $nome_anexo = nl2br(utf8_encode($detalhes["arquivo"]));
	         echo 'anexos_atualizar_atendimento.set(\'' . $id_anexo . '\', \'' . $nome_anexo . '\');' . "\n";
	       }
		 }
       ?> 
	  
	   exibir_lista_anexos_atualizar_atendimento(); 
	  
	   function atualizar_valor_total_pagamento_visualizar(){
		  var acrescimos = $('#acrescimo_pagamento_visualizar').val();
		  var descontos = $('#abatimento_pagamento_visualizar').val();
		  var valor = $('#valor_pagamento_visualizar').val();
		  
		  if(acrescimos.trim() == ""){
			return;  
		  }
		  if(valor.trim() == ""){
			return;  
		  }
		  if(descontos.trim() == ""){
			return;  
		  }
		  
		  valor = valor.replace(".", "");
		  valor = valor.replace(",", ".");
		  acrescimos = acrescimos.replace(".", "");
		  acrescimos = acrescimos.replace(",", ".");
		  descontos = descontos.replace(".", "");
		  descontos = descontos.replace(",", ".");
		  var valor_total = parseFloat(valor) + parseFloat(acrescimos) - parseFloat(descontos);
		  $('#total_pagamento_visualizar').val(valor_total.toLocaleString('pt-br', {minimumFractionDigits: 2}));	
		}
		<?php } ?>
	</script>   
	    
    <script type="text/javascript">

    var $modal = undefined; 

$(document).ready(function(){
    $modal = $('#modal');

	var image = document.getElementById('sample_image');

	var cropper;

	$('#upload_image').change(function(event){
		var files = event.target.files;

		var done = function(url){
			image.src = url;
			$('#crop').attr('disabled',false);
			$('#crop').html('Recortar e Salvar');
			$modal.modal('show');
		};

		if(files && files.length > 0)
		{
			reader = new FileReader();
			reader.onload = function(event)
			{
				done(reader.result);
			};
			reader.readAsDataURL(files[0]);
		}
	});

	$modal.on('shown.bs.modal', function() {
		cropper = new Cropper(image, {
			aspectRatio: 1,
			viewMode: 3,
			preview:'.preview'
		});
	}).on('hidden.bs.modal', function(){
		cropper.destroy();
   		cropper = null;
	});

	$('#crop').click(function(){
		$('#crop').attr('disabled','disabled');
		$('#crop').html('<i class="fa fa-circle-o-notch fa-spin"></i> Processando...');
		canvas = cropper.getCroppedCanvas({
			width:400,
			height:400
		});

		canvas.toBlob(function(blob){
			url = URL.createObjectURL(blob);
			var reader = new FileReader();
			reader.readAsDataURL(blob);
			reader.onloadend = function(){
				var base64data = reader.result;
				$.ajax({
					url:'upload_clientes_fornecedores.php',
					method:'POST',
					data:{image:base64data, nome_imagem: '<?= $foto_cliente_fornecedor ?>'},
					success:function(data)
					{
						$modal.modal('hide');
						$('#uploaded_image').attr('src', data);
					}
				});
			};
		});
	});
	
});

  function fecharCrop(){
	 $modal.modal('hide');
  }
  
  var $modal_excluir = $('#janela_excluir_cliente_fornecedor');
  var $modal_excluir_atendimento = $('#janela_excluir_atendimento');
  var $modal_excluir_anexo = $('#janela_excluir_anexo');
  var id_exlusao = 0;
  var nome_cliente_fornecedor_exclusao;
  var nome_atendimento_exclusao;
  var nome_anexo_exclusao;
  var tipo_anexo;
	   
  function excluir_registro(id, cliente_fornecedor){
	id_exclusao = id;
	nome_cliente_fornecedor_exclusao = cliente_fornecedor;
	$('#msg_excluir').html("Voce deseja mesmo excluir o <?= ($tipo == "1") ? 'cliente' : 'fornecedor' ?> <b>" + cliente_fornecedor + "</b>?<br><br>Se houver lancamentos para este <?= ($tipo == "1") ? 'cliente' : 'fornecedor' ?>, a exclusao sera abortada");
	$modal_excluir.modal('show');    
  }
	   
  function confirmar_exclusao(){
	 var url_volta = 'clientes_fornecedores.php?tipo=<?= $tipo ?>';
     window.location = "excluir_cliente_fornecedor.php?tipo=<?= $tipo ?>&cliente_fornecedor=" + id_exclusao + "&nome_cliente_fornecedor=" + nome_cliente_fornecedor_exclusao + "&volta=" + url_volta;    
  }
	
  function confirmar_exclusao_atendimento(){
	 var url_volta = 'clientes_fornecedores.php?tipo=<?= $tipo ?>';
     window.location = "excluir_atendimento.php?atendimento=" + id_exclusao + "&nome_atendimento=" + nome_atendimento_exclusao + "&volta=" + url_volta;    
  }
  
  function confirmar_exclusao_anexo(){
	 // vamos chamar um c�digo Ajax para excluir o arquivo, tanto na tabela de
     // anexos quanto no diret�rio
     var dados = {'nome_arquivo': nome_anexo_exclusao}

     $.ajax({
       url: 'excluir_documento_atendimentos_ajax.php',
       type: 'post',
       dataType: 'xml',
       data: dados,
       success: function(data){
	     if(tipo_anexo == "NOVO"){
	       anexos_novo_atendimento.delete(id_exclusao);
	       exibir_lista_anexos_novo_atendimento();
	     }
	     else{
		   anexos_atualizar_atendimento.delete(id_exclusao);
	       exibir_lista_anexos_atualizar_atendimento();  
	     }
		 $modal_excluir_anexo.modal('hide');	
       },
       error: function(XMLHttpRequest, textStatus, errorThrown){
          window.alert('Houve um erro! Erro: ' + errorThrown.toString());
       }
     });
     // fim chamar um c�digo Ajax para excluir o anexo	
  }	
	   
  function fechar_exclusao(){
	 $modal_excluir.modal('hide');
  }
  
  function excluir_atendimento(id, atendimento){
	id_exclusao = id;
	nome_atendimento_exclusao = atendimento;
	$('#msg_excluir2').html("Voce deseja mesmo excluir o atendimento <b>" + atendimento + "</b>?");
	$modal_excluir_atendimento.modal('show');    
  }
  
  function excluir_anexo(tipo, id, anexo){
	id_exclusao = id;
	nome_anexo_exclusao = anexo;
	tipo_anexo = tipo;
	$('#msg_excluir3').html("Voce deseja mesmo excluir o anexo <b>" + anexo + "</b>?");
	$modal_excluir_anexo.modal('show');    
  }
	   
  function fechar_exclusao_atendimento(){
	 $modal_excluir_atendimento.modal('hide');
  }
  
  function fechar_exclusao_anexo(){
	 $modal_excluir_anexo.modal('hide');
  }
  
  function atualizar_info_lado(){
	$('#foto_fantasia_cliente_fornecedor').html('<b>' + $('#fantasia').val() + '</b>');
	$('#foto_cidade_estado_cliente_fornecedor').html($('#cidade').val() + " - " + $('#estado').val());
	$('#foto_info_cliente_fornecedor').html($('#info').val());   
  }
  
  function efetuar_upload_novo_atendimento(){
	var arquivo = document.getElementById("arquivo_novo_atendimento");
    arquivo.click();  
  }
  
  function efetuar_upload_atualizar_atendimento(){
	var arquivo = document.getElementById("arquivo_atualizar_atendimento");
    arquivo.click();  
  }
  
  function efetuar_upload(){
	var arquivo = document.getElementById("arquivo");
    arquivo.click();  
  }
  
  function enviar_arquivo(event){
	var id_para_mensagem = "";
	var id_unico_arquivo = Math.round(new Date().getTime()).toString(); 
    var id_arquivo_foto = "" + id_unico_arquivo + "_" + id_para_mensagem.toString();
    var fd = new FormData();
	fd.append('fname', id_arquivo_foto + "_" + document.atualizar_atendimento.arquivo.value.split('\\').pop());
    fd.append('arquivo', document.atualizar_atendimento.arquivo.files[0]);
	fd.append('id_atendimento', '<?= $id_atendimento ?>');
	fd.append('tipo', '<?= $tipo ?>');
	$.ajax({
       type: 'POST',
       url: 'enviar_documento_atendimentos_ajax.php',
       data: fd,
       processData: false,
       contentType: false
    }).done(function(data) {
       window.location.reload();
    }); 
  }
  
  function enviar_arquivo_novo_atendimento(event){
	var id_para_mensagem = "";
	var id_unico_arquivo = Math.round(new Date().getTime()).toString(); 
    var id_arquivo_foto = "" + id_unico_arquivo + "_" + id_para_mensagem.toString();
    var fd = new FormData();
	fd.append('fname', id_arquivo_foto + "_" + document.cadastro_atendimento.arquivo_novo_atendimento.value.split('\\').pop());
    fd.append('arquivo', document.cadastro_atendimento.arquivo_novo_atendimento.files[0]);
	fd.append('id_atendimento', '0');
	fd.append('tipo', '<?= $tipo ?>');
	fd.append('id_unico_atendimento', '<?= $id_unico_atendimento ?>');
	
	$.ajax({
       type: 'POST',
       url: 'enviar_documento_atendimentos_ajax.php',
       data: fd,
       processData: false,
       contentType: false
    }).done(function(data) {
       anexos_novo_atendimento.set(id_unico_arquivo, data);
	   exibir_lista_anexos_novo_atendimento();
    }); 
  }
  
  function enviar_arquivo_atualizar_atendimento(event){
	var id_para_mensagem = "";
	var id_unico_arquivo = Math.round(new Date().getTime()).toString(); 
    var id_arquivo_foto = "" + id_unico_arquivo + "_" + id_para_mensagem.toString();
    var fd = new FormData();
	fd.append('fname', id_arquivo_foto + "_" + document.atualizar_atendimento.arquivo_atualizar_atendimento.value.split('\\').pop());
    fd.append('arquivo', document.atualizar_atendimento.arquivo_atualizar_atendimento.files[0]);
	fd.append('id_atendimento', '<?= $id_atendimento ?>');
	fd.append('tipo', '<?= $tipo ?>');
	fd.append('id_unico_atendimento', '<?= $id_unico_atendimento ?>');
	
	$.ajax({
       type: 'POST',
       url: 'enviar_documento_atendimentos_ajax.php',
       data: fd,
       processData: false,
       contentType: false
    }).done(function(data) {
       anexos_atualizar_atendimento.set(id_unico_arquivo, data);
	   exibir_lista_anexos_atualizar_atendimento();
    }); 
  }
  
  function exibir_lista_anexos_novo_atendimento(){
	var docs_novo_atendimento = document.getElementById("docs_novo_atendimento");
	docs_novo_atendimento.innerHTML = "";
	for (let [chave, valor] of anexos_novo_atendimento){
      docs_novo_atendimento.innerHTML = docs_novo_atendimento.innerHTML + '<div style="border-bottom: 1px solid #eceff1; padding-top: 5px; padding-bottom: 10px"><a target="_blank" href="<?= $url_documentos_atendimentos ?>/' + valor + '">' + valor + '</a> <a title="Clique para excluir" href="javascript:excluir_anexo(\'NOVO\', \'' + chave + '\', \'' + valor + '\')"><img style="display: inline" border="0" width="25px" src="imagens/excluir.gif"/></a></div>';
    }
  }
  
  $(document).ready(function() {
     // in�cio tabela atendimentos
	 var t = $('#tabela_atendimentos').DataTable( {
        "columnDefs": [ {
            "searchable": false,
            "orderable": false,
            "targets": 0
        }, 
		{"width": '80%', "targets": 0}
		],
        "order": [[ 2, 'desc' ]]
    } );
 
    t.on( 'order.dt search.dt', function () {
        t.column(0, {search:'applied', order:'applied'}).nodes().each( function (cell, i) {
            cell.innerHTML = i+1;
        } );
    } ).draw();
  // fim tabela atendimentos
  
     // in�cio tabela pagamentos
	 var t = $('#tabela_pagamentos').DataTable(
    {"footerCallback": function ( row, data, start, end, display ) {
            var api = this.api();
 
            // Remove the formatting to get integer data for summation
            var intVal = function (i) {
              return typeof i === 'string' ?
                    i.replace(/[\$,]/g, '')*1 :
                    typeof i === 'number' ?
                        i : 0;
            };
 
            // Total over all pages
            total = api
                .column(5)
                .data()
                .reduce( function (a, b) {
                    return intVal(a) + intVal(b);
                }, 0 );
 
            // Total over this page
            pageTotal = api
                .column(5, { page: 'current'} )
                .data()
                .reduce( function (a, b) {
                    return intVal(a) + intVal(b);
                }, 0 );
 
            // Update footer
            $( api.column(5).footer()).html(
              'Total: ' + pageTotal.toLocaleString('pt-BR', { style: 'currency', currency: 'BRL'}) + 
                 ' (de ' + total.toLocaleString('pt-BR', { style: 'currency', currency: 'BRL'}) + ')'
            );
        },
        "columnDefs": [ {
            "searchable": false,
            "orderable": false,
            "targets": 0
        },
        {
            "targets": [5],
            "visible": false
          }, 
		{"width": '80%', "targets": 0}
		],
        "order": [[ 2, 'desc' ]]
    } );
 
    t.on( 'order.dt search.dt', function () {
        t.column(0, {search:'applied', order:'applied'}).nodes().each( function (cell, i) {
            cell.innerHTML = i+1;
        } );
    } ).draw();
  // fim tabela pagamentos
  
    // in�cio tabela recebimentos
	 var t = $('#tabela_recebimentos').DataTable(
    {"footerCallback": function ( row, data, start, end, display ) {
            var api = this.api();
 
            // Remove the formatting to get integer data for summation
            var intVal = function (i) {
              return typeof i === 'string' ?
                    i.replace(/[\$,]/g, '')*1 :
                    typeof i === 'number' ?
                        i : 0;
            };
 
            // Total over all pages
            total = api
                .column(5)
                .data()
                .reduce( function (a, b) {
                    return intVal(a) + intVal(b);
                }, 0 );
 
            // Total over this page
            pageTotal = api
                .column(5, { page: 'current'} )
                .data()
                .reduce( function (a, b) {
                    return intVal(a) + intVal(b);
                }, 0 );
 
            // Update footer
            $( api.column(5).footer()).html(
              'Total: ' + pageTotal.toLocaleString('pt-BR', { style: 'currency', currency: 'BRL'}) + 
                 ' (de ' + total.toLocaleString('pt-BR', { style: 'currency', currency: 'BRL'}) + ')'
            );
        }, 
    
        "columnDefs": [ {
            "searchable": false,
            "orderable": false,
            "targets": 0
          },
          {
            "targets": [5],
            "visible": false
          }, 
		      {"width": '80%', "targets": 0}
		      ],
        "order": [[ 2, 'desc' ]]
    } );
 
    t.on( 'order.dt search.dt', function () {
        t.column(0, {search:'applied', order:'applied'}).nodes().each( function (cell, i) {
            cell.innerHTML = i+1;
        } );

    } ).draw();
  // fim tabela recebimentos
  
    // in�cio tabela contas a receber
	 var t = $('#tabela_receber').DataTable( 
    {"footerCallback": function ( row, data, start, end, display ) {
            var api = this.api();
 
            // Remove the formatting to get integer data for summation
            var intVal = function (i) {
              return typeof i === 'string' ?
                    i.replace(/[\$,]/g, '')*1 :
                    typeof i === 'number' ?
                        i : 0;
            };
 
            // Total over all pages
            total = api
                .column(6)
                .data()
                .reduce( function (a, b) {
                    return intVal(a) + intVal(b);
                }, 0 );
 
            // Total over this page
            pageTotal = api
                .column(6, { page: 'current'} )
                .data()
                .reduce( function (a, b) {
                    return intVal(a) + intVal(b);
                }, 0 );
 
            // Update footer
            $( api.column(6).footer()).html(
              'Total: ' + pageTotal.toLocaleString('pt-BR', { style: 'currency', currency: 'BRL'}) + 
                 ' (de ' + total.toLocaleString('pt-BR', { style: 'currency', currency: 'BRL'}) + ')'
            );
        }, 
        "columnDefs": [ {
            "searchable": false,
            "orderable": false,
            "targets": 0
        },
        {
            "targets": [6],
            "visible": false
          },  
		{"width": '80%', "targets": 0}
		],
        "order": [[ 2, 'desc' ]]
    } );
 
    t.on( 'order.dt search.dt', function () {
        t.column(0, {search:'applied', order:'applied'}).nodes().each( function (cell, i) {
            cell.innerHTML = i+1;
        } );
    } ).draw();
  // fim tabela contas a receber
	
	
	// in�cio tabela contas a pagar
	 var t = $('#tabela_pagar').DataTable(
    {"footerCallback": function ( row, data, start, end, display ) {
            var api = this.api();
 
            // Remove the formatting to get integer data for summation
            var intVal = function (i) {
              return typeof i === 'string' ?
                    i.replace(/[\$,]/g, '')*1 :
                    typeof i === 'number' ?
                        i : 0;
            };
 
            // Total over all pages
            total = api
                .column(6)
                .data()
                .reduce( function (a, b) {
                    return intVal(a) + intVal(b);
                }, 0 );
 
            // Total over this page
            pageTotal = api
                .column(6, { page: 'current'} )
                .data()
                .reduce( function (a, b) {
                    return intVal(a) + intVal(b);
                }, 0 );
 
            // Update footer
            $( api.column(6).footer()).html(
              'Total: ' + pageTotal.toLocaleString('pt-BR', { style: 'currency', currency: 'BRL'}) + 
                 ' (de ' + total.toLocaleString('pt-BR', { style: 'currency', currency: 'BRL'}) + ')'
            );
        },
        "columnDefs": [ {
            "searchable": false,
            "orderable": false,
            "targets": 0
        },
        {
            "targets": [6],
            "visible": false
          }, 
		{"width": '80%', "targets": 0}
		],
        "order": [[ 2, 'desc' ]]
    } );
 
    t.on( 'order.dt search.dt', function () {
        t.column(0, {search:'applied', order:'applied'}).nodes().each( function (cell, i) {
            cell.innerHTML = i+1;
        } );
    } ).draw();
  // fim tabela contas a pagar
	
  } );
</script>
    
    
    
    
    
    </body>
</html>

