<?php
  //ini_set('default_charset', "");  

  // vamos efetuar a conexao com o banco
  $servidor = "localhost";
  $usuario = "root";
  $senha = ""; // XAMP e WAMP padrão a senha é em branco
  $base_dados = "finantotal";
  $conexao = mysqli_connect($servidor, $usuario,
    $senha, $base_dados);

  // conexao efetuada com sucesso?
  if(mysqli_connect_errno()) {
    echo "<h1>Nao foi possível efetuar a conexao com o MySQL: "
      . mysqli_connect_error() . "</h1>";
    // vamos sair daqui
    die();
  }
  else{
	///echo '<h1>Conexao efetuada com sucesso.</h1>';  
  }
  
  // define o título da aplicaçao. Aparece na tag title das páginas
  $titulo_aplicacao = "FinanTotal - Contas a Pagar e a Receber";
  
  // URL base da aplicaçao. Se for HTTP, nao se esqueça de colocar
  // Exemplo: "http://localhost/finantotal"
  $url_base_aplicacao = "http://localhost/finantotal";
  
  // caminho completo para a aplicaçao no servidor. Na dúvida use phpinfo(); para descobrir
  // $caminho_base_aplicacao = "C:\\xampp\\htdocs\\finantotal";
  // Exemplo: "/home/arquivodecodigos/www/"
  $caminho_base_aplicacao = "C:\\xampp\\htdocs\\finantotal";
  
  // caminho no servidor para o diretório de fotos dos usuários. Deve ter permissao de escrita
  // atençao: há um diretório temporário que é limpo todos os dias
  $diretorio_fotos_usuarios = $caminho_base_aplicacao . "/uploads/usuarios";
  $diretorio_fotos_produtos = $caminho_base_aplicacao . "/uploads/produtos";
  $diretorio_fotos_clientes_fornecedores = $caminho_base_aplicacao . "/uploads/clientes_fornecedores";
  
  // url o diretório de fotos dos usuários.
  $url_fotos_usuarios = $url_base_aplicacao . "/uploads/usuarios";
  $url_fotos_produtos = $url_base_aplicacao . "/uploads/produtos";
  $url_fotos_clientes_fornecedores = $url_base_aplicacao . "/uploads/clientes_fornecedores";
  
  // url o diretório de documentos.
  $diretorio_documentos_atendimentos = $caminho_base_aplicacao . "/uploads/atendimentos";
  $url_documentos_atendimentos = $url_base_aplicacao . "/uploads/atendimentos";
  $diretorio_documentos_pagamentos_recebimentos = $caminho_base_aplicacao . "/uploads/pagamentos_recebimentos";
  $url_documentos_pagamentos_recebimentos = $url_base_aplicacao . "/uploads/pagamentos_recebimentos";
  // extensões de documentos permitidos
  $documentos_permitidos = array('webp','gif','jpg','jpeg','png');
  // extensões de documentos permitidos elemento file
  $documentos_permitidos_elemento_file = "image/gif, image/jpeg, image/png, image/webp";
  
  // quantidade de registros por página
  $paginacao_padrao = 20;
  $opcoes_paginacao = array(5, 10, 20, 50, 100, 150, 200, 300, 400, 500);
  $opcoes_paginacao_logs = array(100, 200, 300, 400, 500);
  
  // trata os níveis de acesso dos usuários
  class Permissao{
	public static $niveis = array();
	
	public static function obterNiveis(){
	  $niveis = array();
	  $niveis[1] = "Nível 1 - Administrador";
	  $niveis[2] = "Nível 2 - Cadastra, Altera, Exclui";
	  $niveis[3] = "Nível 3 - Cadastra e Altera";
	  $niveis[4] = "Nível 4 - Só Cadastra";
	  $niveis[5] = "Nível 5 - Somente Leitura";
	  return $niveis;	
	}
	
	public static function podeCadastrar($nivel){
	  if($nivel != 5){
		return true;  
	  }
	  return false;
	}
	
	public static function podeExcluir($nivel){
	  if(($nivel == 1) || ($nivel == 2)){
		return true;  
	  }
	  return false;
	}
	
	public static function podeAlterar($nivel){
	  if(($nivel == 1) || ($nivel == 2) || ($nivel == 3)){
		return true;  
	  }
	  return false;
	}
  }
  
  // função que permite informar o id e retornar o nome de usuário que efetuou alguma ação
  function obterNomeUsuarioId($id){
    // por padrão, vamos assumir "admin"
	$nome = "admin";
	global $conexao;
	$result = mysqli_query($conexao, "select usuario from usuarios where id = '$id'");
    if($result){
	   while($detalhes = mysqli_fetch_array($result)){
	     $nome = utf8_encode($detalhes["usuario"]);
	   }
	}
	
	return $nome;
  }
  
  // função que permite informar o id e retornar o nome fantasia de um cliente ou fornecedor
  function obterNomeFantasiaId($id){
    $dados = array("NÃO INFORMADO", 0);
	global $conexao;
	$result = mysqli_query($conexao, "select fantasia, tipo from clientes_fornecedores where id = '$id'");
    if($result){
	   while($detalhes = mysqli_fetch_array($result)){
	     $nome = utf8_encode($detalhes["fantasia"]);
		 $tipo = utf8_encode($detalhes["tipo"]);
		 $dados[0] = $nome;
		 $dados[1] = $tipo;
	   }
	}
	
	return $dados;
  }
  
  // função que permite informar o id e retornar o nome do tipo de contas
  function obterNomeTipoContaId($id){
    global $conexao;
	$result = mysqli_query($conexao, "select nome from tipos_contas where id = '$id'");
    if($result){
	   while($detalhes = mysqli_fetch_array($result)){
	     $nome = utf8_encode($detalhes["nome"]);
	   }
	}
	
	return $nome;
  }
  
  // funçao que permite obter o IP do usuário logado
  function getUserIpAddr(){
    if(!empty($_SERVER['HTTP_CLIENT_IP'])){
        //ip from share internet
        $ip = $_SERVER['HTTP_CLIENT_IP'];
    }elseif(!empty($_SERVER['HTTP_X_FORWARDED_FOR'])){
        //ip pass from proxy
        $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
    }else{
        $ip = $_SERVER['REMOTE_ADDR'];
    }
    
	if(strlen(trim($ip)) < 5){
	  return getHostByName(getHostName()); // rodando localmente?
	}
	else{
	  return $ip;	
	}
  }

  function tratar_entrada($string){
    // há muitos tratamentos a serem feitos, mas inicialmente vamos
    // apenas retirar as aspas simples. São elas que costumam ser usadas
    // para SQL injection
    $string = str_replace("'", '', $string);
    // vamos retirar tags também
    $string = str_replace('<', '', $string);
    $string = str_replace('>', '', $string);
	// alguns engraçadinhos gostam de testar diretórios
	$string = str_replace('../', '', $string);
	$string = str_replace('..%2F', '', $string);
    return $string;	
  }
  
  function sanitizeString($str) {
    $str = preg_replace('/[áàãâä]/ui', 'a', $str);
    $str = preg_replace('/[éèêë]/ui', 'e', $str);
    $str = preg_replace('/[íìîï]/ui', 'i', $str);
    $str = preg_replace('/[óòõôö]/ui', 'o', $str);
    $str = preg_replace('/[úùûü]/ui', 'u', $str);
    $str = preg_replace('/[ç]/ui', 'c', $str);
    // $str = preg_replace('/[,(),;:|!"#$%&/=?~^><ªº-]/', '_', $str);
    // $str = preg_replace('/[^a-z0-9]/i', '_', $str);
    $str = str_replace(' ', '_', $str);
    $str = str_replace('-', '_', $str);
    $str = preg_replace('/_+/', '_', $str); // ideia do Bacco :)
    return $str;
  }
  
  // configuração das datas inicias e finais dos relatórios de receitas e despesas
  if(isset($_GET["data_inicial"])){
    $data_inicial = $_GET["data_inicial"];
    $data_final = $_GET["data_final"];
  }
  else{
	$data_inicial = mktime(0, 0, 0, date("m") - 1, date("d"), date("Y")); // um mês atrás
    $data_final = mktime(0, 0, 0, date("m"), date("d"), date("Y")); // hoje 
    $data_inicial = date("Y-m-d", $data_inicial);
    $data_final = date("Y-m-d", $data_final);   
  }
  
  $data_inicial_str = explode("-", $data_inicial);
  $data_inicial_str = $data_inicial_str[2] . "/" . $data_inicial_str[1] . "/" . $data_inicial_str[0];
  $data_final_str = explode("-", $data_final);
  $data_final_str = $data_final_str[2] . "/" . $data_final_str[1] . "/" . $data_final_str[0];
  // fim configuração das datas iniciais e finais dos relatórios de receitas e despesas
  
   // configuração das datas inicias e finais dos relatórios de contas a pagar e contas a receber
  if(isset($_GET["data_inicial_2"])){
    $data_inicial_2 = $_GET["data_inicial_2"];
    $data_final_2 = $_GET["data_final_2"];
  }
  else{
	$data_inicial_2 = mktime(0, 0, 0, date("m"), date("d"), date("Y")); // hoje
    $data_final_2 = mktime(0, 0, 0, date("m") + 1, date("d"), date("Y")); // daqui um mês
    $data_inicial_2 = date("Y-m-d", $data_inicial_2);
    $data_final_2 = date("Y-m-d", $data_final_2);   
  }
  
  $data_inicial_str_2 = explode("-", $data_inicial_2);
  $data_inicial_str_2 = $data_inicial_str_2[2] . "/" . $data_inicial_str_2[1] . "/" . $data_inicial_str_2[0];
  $data_final_str_2 = explode("-", $data_final_2);
  $data_final_str_2 = $data_final_str_2[2] . "/" . $data_final_str_2[1] . "/" . $data_final_str_2[0];
  // fim configuração das datas iniciais e finais dos relatórios de contas a pagar e contas a receber
?>