<?php
  session_start();
  require("config.php");
  // o usuário está logado?
  if(!isset($_SESSION["id_usuario_logado"])){
    header("Location: login.php");
    exit;
  }
  
  // id do pagamento ou recebimeno a ser visualizado
  $id_conta_pagar_receber = (int)(trim($_GET["conta_pagar_receber"]));
  $tipo = (int)(trim($_GET["tipo"]));
  $result = mysqli_query($conexao, "select id, id_cliente_fornecedor, tipo, id_plano, descricao, DATE_FORMAT(vencimento, '%d/%m/%Y') as data_vencimento, DATE_FORMAT(data_cadastro, '%d/%m/%Y - %H:%i') as data_cadastro_lanc, valor, usuario_cadastro from contas_pagar_receber WHERE id = '$id_conta_pagar_receber'");
  if($result){
	while($detalhes = mysqli_fetch_array($result)){
	   $tipo = utf8_encode($detalhes["tipo"]);
	   $cliente_fornecedor = utf8_encode($detalhes["id_cliente_fornecedor"]);
	   $descricao = utf8_encode($detalhes["descricao"]);
	   $plano = $detalhes["id_plano"];
	   $data_vencimento = $detalhes["data_vencimento"];
	   $valor = $detalhes["valor"];
	   $data_cadastro = $detalhes["data_cadastro_lanc"];
	   $usuario_cadastro = utf8_encode($detalhes["usuario_cadastro"]);
	}
  }
  
  // vamos registrar esse log
  $ip = getUserIpAddr();
  $id_usuario_logado = $_SESSION["id_usuario_logado"];
  $usuario_logado = $_SESSION["usuario_logado"];
  $texto_log = 'O usuario ' . $usuario_logado . ' acessou a ' . (($tipo == "1") ? 'conta a pagar ' : 'conta a receber ') . $descricao . '.';
  $result_2 = mysqli_query($conexao, "INSERT into logs values (null, '$id_usuario_logado', '$texto_log', 
    NOW(), '$usuario_logado', '$ip')");
  // fim registrar o log
?>
<!DOCTYPE html>
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-2" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge" />
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
  <meta name="description" content="" />
  <meta name="author" content="" />
  <title><?= $titulo_aplicacao ?> - <?= ($tipo == "1") ? 'Conta a Pagar' : 'Conta a Receber' ?></title>
  <link rel="stylesheet" href="bootstrap-icons-1.5.0/font/bootstrap-icons.css" />
  <link href="css/styles.css?<?= date('Y-m-d_H:i:s'); ?>" rel="stylesheet" />
  <link rel="stylesheet" href="css/classic.css">
  <link rel="stylesheet" href="css/classic.date.css">
  
  <script src="js/jquery.min.js"></script>
  
  <script src="font-awesome/js/all.min.js" crossorigin="anonymous"></script>
  
  <style type="text/css">
    a{text-decoration:none} 
    .has-search .form-control {
    padding-left: 2.375rem;
    }

   .has-search .form-control-feedback {
    position: absolute;
    z-index: 2;
    display: block;
    width: 2.375rem;
    height: 2.375rem;
    line-height: 2.375rem;
    text-align: center;
    pointer-events: none;
    color: #aaa;
}

.blue-text {
    color: #00BCD4
}

.form-control-label {
    margin-bottom: 0
}

input,
textarea,
button {
    padding: 8px 15px;
    border-radius: 5px !important;
    margin: 5px 0px;
    box-sizing: border-box;
    border: 1px solid #ccc;
    font-size: 18px !important;
    font-weight: 300
}

input:focus,
textarea:focus {
    -moz-box-shadow: none !important;
    -webkit-box-shadow: none !important;
    box-shadow: none !important;
    border: 1px solid #00BCD4;
    outline-width: 0;
    font-weight: 400
}

.btn-block {
    text-transform: uppercase;
    font-size: 15px !important;
    font-weight: 400;
    height: 43px;
    cursor: pointer
}

.btn-block:hover {
    color: #fff !important
}

button:focus {
    -moz-box-shadow: none !important;
    -webkit-box-shadow: none !important;
    box-shadow: none !important;
    outline-width: 0
}

.image_area {
		  position: relative;
		}

		img {
		  	display: block;
		  	max-width: 100%;
		}

		.preview {
  			overflow: hidden;
  			width: 160px; 
  			height: 160px;
  			margin: 10px;
  			border: 1px solid red;
		}

		.modal-lg{
  			max-width: 1000px !important;
		}

		.overlay {
		  position: absolute;
		  bottom: 10px;
		  left: 0;
		  right: 0;
		  background-color: rgba(255, 255, 255, 0.5);
		  overflow: hidden;
		  height: 0;
		  transition: .5s ease;
		  width: 100%;
		}

		.image_area:hover .overlay {
		  height: 50%;
		  cursor: pointer;
		}

		.text {
		  color: #333;
		  font-size: 20px;
		  position: absolute;
		  top: 50%;
		  left: 50%;
		  -webkit-transform: translate(-50%, -50%);
		  -ms-transform: translate(-50%, -50%);
		  transform: translate(-50%, -50%);
		  text-align: center;
		}

  </style>
</head>

<body class="sb-nav-fixed">

<?php require("cima.php"); ?>

<div id="layoutSidenav">
           
           <?php require("menu_lado.php"); ?>
           
            <div id="layoutSidenav_content">
                <main>
                    <div class="container-fluid px-4">
                        
                        <h1 class="mt-4"><i class="bi-clipboard"></i> <?= ($tipo == "1") ? 'Conta a Pagar' : 'Conta a Receber' ?></h1>
                        
                        <ol class="breadcrumb mb-4">
                            <li class="breadcrumb-item"><a href="index.php">P&aacute;gina Inicial</a></li>
                            <li class="breadcrumb-item active">Detalhes da <?= ($tipo == "1") ? 'Conta a Pagar' : 'Conta a Receber' ?></li>
                        </ol>
                        
                        <?php if(isset($_GET["sucesso"])){ ?>
						
                        <div class="alert alert-success" role="alert">
                          A Conta a <?= ($tipo == "1") ? 'Pagar' : 'Receber' ?> foi atualizada com sucesso.
                         </div>
                         
                        <?php } ?>
						
                        <div class="row">
                            <div class="col-xl-8">
                                <div class="card mb-4">
                                    <div class="card-header">
                                        <i class="bi-clipboard-data"></i>
                                        Dados da Conta a <?= ($tipo == "1") ? 'Pagar' : 'Receber' ?>
                                    </div>
                                    <div class="card-body">
                                    
                                    <form id="cadastro_conta_pagar_receber" name="cadastro_conta_pagar_receber" action="atualizar_conta_pagar_receber_action.php" method="post" class="form-card">
                                    
                                    
                                    <?php
                                      if(isset($_GET["aba_pagar"])){ 
									   echo '<div style="padding-left: 4px; padding-bottom: 10px"><a href="cliente_fornecedor.php?aba_pagamentos=show&tipo=' . $_GET["tipo"] . '&cliente_fornecedor=' . $_GET["cliente_fornecedor"] . '"><i class="bi-arrow-left-circle-fill"></i> Voltar para a rela&ccedil;&atilde;o de pagamentos do cliente/fornecedor ' . $_GET["nome"] . '</a></div>';
									  }
									  else if(isset($_GET["aba_receber"])){ 
									   echo '<div style="padding-left: 4px; padding-bottom: 10px"><a href="cliente_fornecedor.php?aba_receber=show&tipo=' . $_GET["tipo"] . '&cliente_fornecedor=' . $_GET["cliente_fornecedor"] . '"><i class="bi-arrow-left-circle-fill"></i> Voltar para a rela&ccedil;&atilde;o de contas a receber do cliente/fornecedor ' . $_GET["nome"] . '</a></div>';
									  }
                                    ?>
                                    
                                    
                                    <div class="row justify-content-between text-left">
                                       <div class="form-group col-12 flex-column d-flex">
                                       <label style="padding-left: 5px" class="form-control-label">Cliente/Fornecedor<span class="text-danger"> *</span></label>
                                          <select name="id_cliente_fornecedor" id="id_cliente_fornecedor" style="margin-bottom: 10px; margin-top: 10px" class="form-select">
                                             <option selected value="0">NAO SE APLICA</option>
											 <?php
											   $result = mysqli_query($conexao, "SELECT id, fantasia from clientes_fornecedores ORDER BY fantasia");
                                               if($result){
	                                              while($detalhes = mysqli_fetch_array($result)){
	                                                 $id_cliente_fornecedor = utf8_encode($detalhes["id"]);
	                                                 $nome_cliente_fornecedor = utf8_encode($detalhes["fantasia"]);
													 if($id_cliente_fornecedor == $cliente_fornecedor){
													   echo '<option selected value="' . $id_cliente_fornecedor . '">' . $nome_cliente_fornecedor . '</option>';
													 }
													 else{
													   echo '<option value="' . $id_cliente_fornecedor . '">' . $nome_cliente_fornecedor . '</option>';	 
													 }
												  }
											   }
											 ?>
                                          </select>
                                       </div>
                                    </div>
                                    
                                    <div class="row justify-content-between text-left">
                                       <div class="form-group col-12 flex-column d-flex">
                                          <label style="padding-left: 5px" class="form-control-label">Descriçao da Conta<span class="text-danger"> *</span></label>
                                          <textarea required class="form-control" onBlur="this.value = this.value.toUpperCase();" name="descricao" id="descricao" rows="3"><?= $descricao ?></textarea>
                                       </div>
                                    </div>
                                    
                                    <div class="row justify-content-between text-left">
                                       <div class="form-group col-12 flex-column d-flex">
                                       <label style="padding-left: 5px" class="form-control-label">Plano de Contas<span class="text-danger"> *</span></label>
                                          <select name="plano" id="plano" style="margin-bottom: 10px; margin-top: 10px" class="form-select">
                                             <?php
											   $result = mysqli_query($conexao, "SELECT id, nome from plano_contas WHERE id_tipo_conta = '$tipo'");
                                               if($result){
	                                              while($detalhes = mysqli_fetch_array($result)){
	                                                 $id_plano_conta = utf8_encode($detalhes["id"]);
	                                                 $nome_plano_conta = utf8_encode($detalhes["nome"]);
													 if($id_plano_conta == $plano){
													    echo '<option selected value="' . $id_plano_conta . '">' . $nome_plano_conta . '</option>';
													 }
													 else{
														echo '<option value="' . $id_plano_conta . '">' . $nome_plano_conta . '</option>'; 
													 }
												  }
											   }
											 ?>
                                          </select>
                                       </div>
                                    </div>
                                    
                                    <div class="row justify-content-between text-left">    
                                        <div class="form-group col-sm-6 flex-column d-flex">
                                         <label style="padding-left: 5px" class="form-control-label">Valor<span 
                                           class="text-danger"> *</span></label>
                                         <input type="text" name="valor" required value="<?= number_format($valor, 2, ',', '.') ?>" id="valor" style="text-align: right;">
                                        </div>
                                        <div class="form-group col-sm-6 flex-column d-flex">
                                          <label style="padding-left: 5px" class="form-control-label">Vencimento<span class="text-danger"> *</span></label>
                                         <input type="text" style="margin-bottom: 10px; margin-top: 10px" required class="form-control" value="<?= $data_vencimento ?>" name="vencimento" id="vencimento" placeholder="Escolha a data"> 
                                       </div>
                                    </div>
                                    
                                    <div class="row justify-content-between text-left">    
                                        <div class="form-group col-sm-6 flex-column d-flex">
                                         <label style="padding-left: 5px" class="form-control-label">C&oacute;digo Lan&ccedil;amento<span class="text-danger"> *</span></label>
                                         <input required type="text" disabled="disabled" id="codigo_lancamento" value="<?= $id_conta_pagar_receber ?>" name="codigo_lancamento" placeholder="">
                                       </div>
                                       
                                       <div class="form-group col-sm-6 flex-column d-flex">
                                         <label style="padding-left: 5px" class="form-control-label">Data de Cadastro<span class="text-danger"> *</span></label>
                                         <input required type="text" disabled="disabled" id="data_cadastro" value="<?= $data_cadastro ?>" name="data_cadastro" placeholder="">
                                       </div>
                                    </div>
                                       
                                    <div class="row justify-content-between text-left">
                                       <div class="form-group col-sm-6 flex-column d-flex">
                                           <label style="padding-left: 5px" class="form-control-label">Usu&aacute;rio Cadastro<span class="text-danger"> *</span></label>
                                         <input required type="text" disabled="disabled" id="usuario_cadastro" value="<?= obterNomeUsuarioId($usuario_cadastro) ?>" name="usuario_cadastro" placeholder="">
                                       </div>
                                    </div>
                                    
                                    <div class="row justify-content-end">
                                       <div class="form-group col-12 flex-column d-flex">
                                          <div class="btn-group" role="group">
                                            <?php if(Permissao::podeAlterar($_SESSION["nivel_acesso"])){ ?>
                                              <button type="button" name="registrar_pr" onclick="registrar_pagamento_recebimento('<?= $id_conta_pagar_receber ?>')" style="margin-right: 8px; width: 210px" 
                                              class="btn-secondary"><?= ($tipo == "1") ? 'Registrar Pagamento' : 'Registrar Recebimento' ?></button>
                                            <?php } ?> 
                                            
                                            <?php if(Permissao::podeAlterar($_SESSION["nivel_acesso"])){ ?>
                                              <button type="submit" name="gravar" style="margin-right: 8px; width: 180px" 
                                              class="btn-secondary">Atualizar Dados</button>
                                            <?php } ?>
                                            
                                            <?php if(Permissao::podeExcluir($_SESSION["nivel_acesso"])){ ?>
                                              <button type="button" onclick="excluir_registro('<?= $id_conta_pagar_receber ?>', '<?= $descricao ?>')" 
                                              name="excluir" style="width: 180px" class="btn-secondary">Excluir</button>
                                            <?php } ?>
                                          
                                          </div>
                                          <input name="tipo" type="hidden" id="tipo" value="<?= $tipo ?>">
                                          <input name="id_conta_pagar_receber" type="hidden" id="id_conta_pagar_receber" 
                                          value="<?= $id_conta_pagar_receber ?>">
                                       </div>
                                    </div>
                                    
                                    </form>
                                    
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-4">
                                <div class="card mb-4">
                                    <div class="card-header">
                                        <i class="bi-lightbulb"></i>
                                        Dica do Sistema
                                    </div>
                                    <div class="card-body">
                                    
                                    Voc&ecirc; pode inserir algum texto informativo ou de ajuda aqui. Isso tornar&aacute; o sistema mais f&aacute;cil de usar.
                                    
                                    </div>
                                </div>
                            </div>
                            </div>
                        </div>
                     
                </main>
                
                <?php require("rodape.php"); ?>
                
            </div>
        
        
        <div id="janela_excluir_lancamento" class="modal fade" role="dialog" style="width:100%">
    <div class="modal-dialog" style="width: 60%;">
        <div class="modal-content" >
            <div class="modal-header">Excluir</div>
            <div class="modal-body"><span id="msg_excluir"></span></div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" onclick="confirmar_exclusao()">Confirmar</button>
                <button type="button" class="btn btn-secondary" onclick="fechar_exclusao()" data-dismiss="modal">Cancelar</button>
            </div>
        </div>
    </div>
    </div>
        
        </div>
        <script src="bootstrap-5.0.2/js/bootstrap.bundle.min.js" crossorigin="anonymous"></script>
        <script src="js/scripts.js"></script>
    
    
    <script type="text/javascript">
  
  var $modal_excluir = $('#janela_excluir_lancamento');
  var id_exlusao = 0;
  var descricao_lancamento_excluir;

  function registrar_pagamento_recebimento(id){
	window.location = "novo_pagamento_recebimento.php?tipo=<?= $tipo ?>&id_pagamento_recebimento=" + id;  
  }
	   
  function excluir_registro(id, nome){
	id_exclusao = id;
	descricao_lancamento_excluir = nome;
	
	$('#msg_excluir').html("Voce deseja mesmo excluir a conta a <?= ($tipo == "1") ? 'pagar' : 'receber' ?> <b>" + nome + "</b>?<br><br>Esta operacao nao podera ser desfeita.");
	$modal_excluir.modal('show');    
  }
	   
  function confirmar_exclusao(){
	 var url_volta = "contas_pagar_receber.php?tipo=<?= $tipo ?>";
		 window.location = "excluir_conta_pagar_receber.php?conta_pagar_receber=" + id_exclusao + "&descricao_lancamento_excluir=" + descricao_lancamento_excluir + "&volta=" + url_volta;    
  }
	   
  function fechar_exclusao(){
	 $modal_excluir.modal('hide');
  }
  </script>
  
  <script src="js/scripts.js"></script>
        <script src="js/jquery.mask.min.js"></script>
    
    <script type="text/javascript">
	   $(document).ready(function(){
	     // trata a formataao dos campos
	     $('#valor').mask('000.000.000.000.000,00', {reverse: true});
		 $('#acrescimo').mask('000.000.000.000.000,00', {reverse: true});
		 $('#abatimento').mask('000.000.000.000.000,00', {reverse: true});
	     // fim formataao dos campos
	   });
	   
	   function atualizar_valor_total(){
		  var acrescimos = $('#acrescimo').val();
		  var descontos = $('#abatimento').val();
		  var valor = $('#valor').val();
		  
		  if(acrescimos.trim() == ""){
			return;  
		  }
		  if(valor.trim() == ""){
			return;  
		  }
		  if(descontos.trim() == ""){
			return;  
		  }
		  
		  valor = valor.replace(".", "");
		  valor = valor.replace(",", ".");
		  acrescimos = acrescimos.replace(".", "");
		  acrescimos = acrescimos.replace(",", ".");
		  descontos = descontos.replace(".", "");
		  descontos = descontos.replace(",", ".");
		  var valor_total = parseFloat(valor) + parseFloat(acrescimos) - parseFloat(descontos);
		  $('#total').val(valor_total.toLocaleString('pt-br', {minimumFractionDigits: 2}));	
		}
	</script>
    
    <script src="js/popper.min.js"></script>
        <script src="js/picker.js"></script>
        <script src="js/picker.date.js"></script>
        
        <script type="text/javascript">
		  $(function() {
             $('#vencimento').pickadate({
			    today: 'Hoje',
                clear: 'Limpar',
                close: 'Cancelar',
				weekdaysShort: ['D', 'S', 'T', 'Q', 'Q', 'S', 'S'],
                showMonthsShort: true,
				format: 'dd/mm/yyyy',
				formatSubmit: 'yyyy-mm-dd',
                hiddenName: true,
				labelMonthNext: 'Pr&oacute;ximo M&ecirc;s',
                labelMonthPrev: 'M&ecirc;s Anterior',
                labelMonthSelect: 'Selecione o M&ecirc;s',
                labelYearSelect: 'Selecione um Ano',
				monthsFull: ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'],
                monthsShort: ['Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set', 'Out', 'Nov', 'Dez'],
                weekdaysFull: ['Domingo', 'Segunda', 'Ter&ccedil;a', 'Quarta', 'Quinta', 'Sexta', 'S&aacute;bado'] 
			 });
          });
    </script>
    
    
    </body>
</html>

