<?php
session_start();
require("config.php");
// o usuĂĄrio estĂĄ logado?
if(!isset($_SESSION["id_usuario_logado"])){
  header("Location: login.php");
  exit;
}

// tem permissão para excluir?
if(!Permissao::podeExcluir($_SESSION["nivel_acesso"])){
  header("Location: erro_permissao.php");
  exit;  
}
// fim permissão para excluir

// id do pagamento ou recebimento a ser excluido
$pagamento_recebimento = tratar_entrada(utf8_decode(trim($_GET["pagamento_recebimento"])));
$descricao_lancamento_excluir = tratar_entrada(utf8_decode(trim($_GET["descricao_lancamento_excluir"])));
// url para voltar depois da exclusao
$url_volta = tratar_entrada(str_replace("@@", "&", $_GET["volta"]));

// precisamos devolver ou retirar o valor da conta saldo
 $result = mysqli_query($conexao, "select id, tipo, id_cliente_fornecedor, id_conta_saldo, valor, acrescimo, 
  abatimento from pagamentos_recebimentos WHERE id = '$pagamento_recebimento'");
  if($result){
	while($detalhes = mysqli_fetch_array($result)){
	   $tipo = utf8_encode($detalhes["tipo"]);
	   $conta_saldo = $detalhes["id_conta_saldo"];
	   $valor = $detalhes["valor"];
	   $acrescimo = $detalhes["acrescimo"];
	   $abatimento = $detalhes["abatimento"];
	   $valor_total = ($valor + $acrescimo) - $abatimento;
	   
	   if($tipo == "1"){ // foi pagamento.... deve voltar do caixa
	     $result_saldo = mysqli_query($conexao, "UPDATE contas_saldos SET saldo = (saldo + '$valor_total') WHERE id = '$conta_saldo'");
	   }
	   else{ // foi recebimento.... deve sair do caixa
	     $result_saldo = mysqli_query($conexao, "UPDATE contas_saldos SET saldo = (saldo - '$valor_total') WHERE id = '$conta_saldo'");
	   }
	}
  }
// fim precisamos devolver ou retirar o valor da conta saldo

$result = mysqli_query($conexao, "DELETE FROM pagamentos_recebimentos WHERE id = '$pagamento_recebimento'");
if($result){
  // vamos registrar esse log
  $ip = getUserIpAddr();
  $id_usuario_logado = $_SESSION["id_usuario_logado"];
  $usuario_logado = $_SESSION["usuario_logado"];
  $texto_log = 'O usuario ' . $usuario_logado . ' excluiu o lancamento ' . $descricao_lancamento_excluir . '.';
  $result_2 = mysqli_query($conexao, "INSERT into logs values (null, '$id_usuario_logado', '$texto_log', 
    NOW(), '$usuario_logado', '$ip')");
  // fim registrar o log
  
  // precisamos excluir os anexos associados a este pagamento ou recebimento
  $result_anexos = mysqli_query($conexao, "select id, arquivo from anexos_pagamentos_recebimentos WHERE 
  	id_pai = '$pagamento_recebimento'");
  while($detalhes = mysqli_fetch_array($result_anexos)){
    $id_anexo = utf8_encode($detalhes["id"]);
	$nome_anexo = nl2br(utf8_encode($detalhes["arquivo"]));
    unlink($diretorio_documentos_pagamentos_recebimentos . "/" . $nome_anexo);
  }
  
  $result_anexos = mysqli_query($conexao, "DELETE from anexos_pagamentos_recebimentos WHERE 
  	id_pai = '$pagamento_recebimento'");
  // fim excluir anexos
  
  header("Location: $url_volta");
  exit; 
}
else{
  $_SESSION["erro_banco_dados"] = "Houve um erro no cadastro de pagamentos e recebimentos.<br><br>Erro: " . mysqli_error($conexao);
  header("Location: erro_banco_dados.php");
  exit;  
} 
?>
