<?php
  session_start();
  require("config.php");
  // o usurio est logado?
  if(!isset($_SESSION["id_usuario_logado"])){
    header("Location: login.php");
    exit;
  }
?>
<!DOCTYPE html>
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-2" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge" />
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
  <meta name="description" content="" />
  <meta name="author" content="" />
  <title>Controle de Estoque - P&aacute;gina Inicial</title>
  <link rel="stylesheet" href="bootstrap-icons-1.5.0/font/bootstrap-icons.css" />
  <link href="css/styles.css?<?= date('Y-m-d_H:i:s'); ?>" rel="stylesheet" />
  <script src="font-awesome/js/all.min.js" crossorigin="anonymous"></script>
</head>

<body class="sb-nav-fixed">

<?php require("cima.php"); ?>

<div id="layoutSidenav">
            
            <?php require("menu_lado.php"); ?>
            
            <div id="layoutSidenav_content">
                <main>
                    <div class="container-fluid px-4">
                        <h1 class="mt-4"><i class="bi-bar-chart-line"></i> P&aacute;gina Inicial</h1>
                        <ol class="breadcrumb mb-4">
                            <li class="breadcrumb-item active">Vis&atilde;o Geral do Sistema</li>
                        </ol>
                        
                        <div class="row">
                            <div class="col-xl-6">
                                <div class="card mb-4">
                                    <div class="card-header">
                                        <i class="fas fa-chart-area me-1"></i>
                                    Receitas e Despesas &Uacute;ltimos 8 Meses</div>
                                    <div class="card-body">
                                    
                                    <div>
                                      <canvas id="chart_receitas_despesas" width="100%"></canvas>
                                    </div>
                                    
                                  </div>
                                </div>
                            </div>
                            
                            <div class="col-xl-6">
                                <div class="card mb-4">
                                    <div class="card-header">
                                        <i class="bi-lightbulb"></i> Estat&iacute;sticas de Receitas</div>
                                    <div class="card-body">
                                    
                                    <?php
							  $tipo = 2;
							  $este_ano = date("Y");
							  $link_este_ano = 'pagamentos_recebimentos.php?data_inicial=' . $este_ano . '-01-01&data_final=' . 
							    $este_ano . '-12-31&tipo=' . $tipo;
							  
							  $ano_passado = ($este_ano - 1);
							  $link_ano_passado = 'pagamentos_recebimentos.php?data_inicial=' . $ano_passado . '-01-01&data_final=' . 
							    $ano_passado . '-12-31&tipo=' . $tipo;
							  
							  $este_mes = mktime(0, 0, 0, date("m"), date("d"), date("Y"));
							  $link_este_mes = 'pagamentos_recebimentos.php?data_inicial=' . date("Y", $este_mes) . '-' . 
							    date("m", $este_mes) . '-01&data_final=' . date("Y", $este_mes) . '-' . 
							    date("m", $este_mes) . '-' . cal_days_in_month(CAL_GREGORIAN, (int)(date("m", $este_mes)), 
								(int)(date("Y", $este_mes))) . '&tipo=' . $tipo;
							  $este_mes = date("m/Y", $este_mes);
							  
							  $mes_passado = mktime(0, 0, 0, date("m") - 1, date("d"), date("Y"));
							  $link_mes_passado = 'pagamentos_recebimentos.php?data_inicial=' . date("Y", $mes_passado) . '-' . 
							    date("m", $mes_passado) . '-01&data_final=' . date("Y", $mes_passado) . '-' . 
							    date("m", $mes_passado) . '-' . cal_days_in_month(CAL_GREGORIAN, (int)(date("m", $mes_passado)), 
								(int)(date("Y", $mes_passado))) . '&tipo=' . $tipo;
							  $mes_passado = date("m/Y", $mes_passado);
							  
							  $hoje = mktime(0, 0, 0, date("m"), date("d"), date("Y")); // hoje 
                              $hoje_temp = date("Y-m-d", $hoje);
							  $hoje = date("d/m/Y", $hoje);
							  $link_hoje = 'pagamentos_recebimentos.php?data_inicial=' . $hoje_temp . '&data_final=' . 
							    $hoje_temp . '&tipo=' . $tipo;
							  
							  $ontem = mktime(0, 0, 0, date("m"), date("d") - 1, date("Y")); // hoje 
                              $ontem_temp = date("Y-m-d", $ontem);
							  $ontem = date("d/m/Y", $ontem);
							  $link_ontem = 'pagamentos_recebimentos.php?data_inicial=' . $ontem_temp . '&data_final=' . 
							    $ontem_temp . '&tipo=' . $tipo;
							  
							  $result_es = mysqli_query($conexao, "SELECT id FROM pagamentos_recebimentos WHERE tipo = '$tipo'");
                              $quant_lancamentos = mysqli_num_rows($result_es);
							  
							  $result_es = mysqli_query($conexao, "SELECT id FROM pagamentos_recebimentos WHERE tipo = '$tipo' AND YEAR(data_pagamento_recebimento) = '$este_ano'");
                              $quant_lancamentos_este_ano = mysqli_num_rows($result_es);
							  
							  $result_es = mysqli_query($conexao, "SELECT id FROM pagamentos_recebimentos WHERE tipo = '$tipo' AND YEAR(data_pagamento_recebimento) = '$ano_passado'");
                              $quant_lancamentos_ano_passado = mysqli_num_rows($result_es);
							  
							  $result_es = mysqli_query($conexao, "SELECT id FROM pagamentos_recebimentos WHERE tipo = '$tipo' AND 
							    DATE_FORMAT(data_pagamento_recebimento, '%m/%Y') = '$mes_passado'");
                              $quant_lancamentos_mes_passado = mysqli_num_rows($result_es);
							  
							  $result_es = mysqli_query($conexao, "SELECT id FROM pagamentos_recebimentos WHERE tipo = '$tipo' AND 
							    DATE_FORMAT(data_pagamento_recebimento, '%m/%Y') = '$este_mes'");
                              $quant_lancamentos_este_mes = mysqli_num_rows($result_es);
							  
							  $result_es = mysqli_query($conexao, "SELECT id FROM pagamentos_recebimentos WHERE tipo = '$tipo' AND 
							    DATE_FORMAT(data_pagamento_recebimento, '%d/%m/%Y') = '$ontem'");
                              $quant_lancamentos_ontem = mysqli_num_rows($result_es);
							  
							  $result_es = mysqli_query($conexao, "SELECT id FROM pagamentos_recebimentos WHERE tipo = '$tipo' AND 
							    DATE_FORMAT(data_pagamento_recebimento, '%d/%m/%Y') = '$hoje'");
                              $quant_lancamentos_hoje = mysqli_num_rows($result_es);
							  
							  echo '<div style="margin-bottom: 10px; color: #546e7a"><span style="font-size: 100%">No total h&aacute; <b>' . $quant_lancamentos . '</b> lan&ccedil;amentos de ' . (($tipo == "1") ? 'pagamentos' : 'recebimentos') . ' no sistema.</div>';
							  
							  echo '<div class="row">';
							    echo '<div class="col-xl-4">';
							       echo '<div style="font-size: 300%"><b>' . $quant_lancamentos_ano_passado . '</b></div><div style="border-top: 1px solid #bdbdbd">no <a href="' . $link_ano_passado . '">ano passado</a> (' . $ano_passado . ').</div>';  
                                echo '</div>';
							    
								echo '<div class="col-xl-4">';
							       echo '<div style="font-size: 300%"><b>' . $quant_lancamentos_este_ano . '</b></div><div style="border-top: 1px solid #bdbdbd"><a href="' . $link_este_ano . '">neste ano</a> (' . $este_ano . ').</div>';  
                                echo '</div>';
							  
							    echo '<div class="col-xl-4">';
							       echo '<div style="font-size: 300%"><b>' . $quant_lancamentos_mes_passado . '</b></div><div style="border-top: 1px solid #bdbdbd">no <a href="' . $link_mes_passado . '">m&ecirc;s passado</a> (' . $mes_passado . ').</div>';  
                                echo '</div>';
								
								echo '<div class="col-xl-4">';
							       echo '<div style="font-size: 300%"><b>' . $quant_lancamentos_este_mes . '</b></div><div style="border-top: 1px solid #bdbdbd"><a href="' . $link_este_mes . '">neste m&ecirc;s</a> (' . $este_mes . ').</div>';  
                                echo '</div>';
							  
							    echo '<div class="col-xl-4">';
							       echo '<div style="font-size: 300%"><b>' . $quant_lancamentos_ontem . '</b></div><div style="border-top: 1px solid #bdbdbd"><a href="' . $link_ontem . '">ontem</a> (' . $ontem . ').</div>';  
                                echo '</div>';
								
								echo '<div class="col-xl-4">';
							       echo '<div style="font-size: 300%"><b>' . $quant_lancamentos_hoje . '</b></div><div style="border-top: 1px solid #bdbdbd"><a href="' . $link_hoje . '">hoje</a> (' . $hoje . ').</div>';  
                                echo '</div>';
							echo '</div>';
							?>
                                    
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- estatisticas de receitas e despesas //-->
                        <div class="row">
                            <div class="col-xl-6">
                                <div class="card mb-4">
                                   <div class="card-header">
                                        <i class="fas fa-chart-bar me-1"></i>
                                        Contas a Pagar e Receber Pr&oacute;ximos 8 Meses</div>
                                    <div class="card-body">
                                       <canvas id="chart_pagar_receber" width="100%"></canvas>
                                    </div> 
                                  </div>
                                </div>
                            
                            <div class="col-xl-6">
                                <div class="card mb-4">
                                    <div class="card-header">
                                        <i class="bi-lightbulb"></i> Estat&iacute;sticas de Despesas</div>
                                    <div class="card-body">
                                    
                                    <?php
							  $tipo = 1;
							  $este_ano = date("Y");
							  $link_este_ano = 'pagamentos_recebimentos.php?data_inicial=' . $este_ano . '-01-01&data_final=' . 
							    $este_ano . '-12-31&tipo=' . $tipo;
							  
							  $ano_passado = ($este_ano - 1);
							  $link_ano_passado = 'pagamentos_recebimentos.php?data_inicial=' . $ano_passado . '-01-01&data_final=' . 
							    $ano_passado . '-12-31&tipo=' . $tipo;
							  
							  $este_mes = mktime(0, 0, 0, date("m"), date("d"), date("Y"));
							  $link_este_mes = 'pagamentos_recebimentos.php?data_inicial=' . date("Y", $este_mes) . '-' . 
							    date("m", $este_mes) . '-01&data_final=' . date("Y", $este_mes) . '-' . 
							    date("m", $este_mes) . '-' . cal_days_in_month(CAL_GREGORIAN, (int)(date("m", $este_mes)), 
								(int)(date("Y", $este_mes))) . '&tipo=' . $tipo;
							  $este_mes = date("m/Y", $este_mes);
							  
							  $mes_passado = mktime(0, 0, 0, date("m") - 1, date("d"), date("Y"));
							  $link_mes_passado = 'pagamentos_recebimentos.php?data_inicial=' . date("Y", $mes_passado) . '-' . 
							    date("m", $mes_passado) . '-01&data_final=' . date("Y", $mes_passado) . '-' . 
							    date("m", $mes_passado) . '-' . cal_days_in_month(CAL_GREGORIAN, (int)(date("m", $mes_passado)), 
								(int)(date("Y", $mes_passado))) . '&tipo=' . $tipo;
							  $mes_passado = date("m/Y", $mes_passado);
							  
							  $hoje = mktime(0, 0, 0, date("m"), date("d"), date("Y")); // hoje 
                              $hoje_temp = date("Y-m-d", $hoje);
							  $hoje = date("d/m/Y", $hoje);
							  $link_hoje = 'pagamentos_recebimentos.php?data_inicial=' . $hoje_temp . '&data_final=' . 
							    $hoje_temp . '&tipo=' . $tipo;
							  
							  $ontem = mktime(0, 0, 0, date("m"), date("d") - 1, date("Y")); // hoje 
                              $ontem_temp = date("Y-m-d", $ontem);
							  $ontem = date("d/m/Y", $ontem);
							  $link_ontem = 'pagamentos_recebimentos.php?data_inicial=' . $ontem_temp . '&data_final=' . 
							    $ontem_temp . '&tipo=' . $tipo;
							  
							  $result_es = mysqli_query($conexao, "SELECT id FROM pagamentos_recebimentos WHERE tipo = '$tipo'");
                              $quant_lancamentos = mysqli_num_rows($result_es);
							  
							  $result_es = mysqli_query($conexao, "SELECT id FROM pagamentos_recebimentos WHERE tipo = '$tipo' AND YEAR(data_pagamento_recebimento) = '$este_ano'");
                              $quant_lancamentos_este_ano = mysqli_num_rows($result_es);
							  
							  $result_es = mysqli_query($conexao, "SELECT id FROM pagamentos_recebimentos WHERE tipo = '$tipo' AND YEAR(data_pagamento_recebimento) = '$ano_passado'");
                              $quant_lancamentos_ano_passado = mysqli_num_rows($result_es);
							  
							  $result_es = mysqli_query($conexao, "SELECT id FROM pagamentos_recebimentos WHERE tipo = '$tipo' AND 
							    DATE_FORMAT(data_pagamento_recebimento, '%m/%Y') = '$mes_passado'");
                              $quant_lancamentos_mes_passado = mysqli_num_rows($result_es);
							  
							  $result_es = mysqli_query($conexao, "SELECT id FROM pagamentos_recebimentos WHERE tipo = '$tipo' AND 
							    DATE_FORMAT(data_pagamento_recebimento, '%m/%Y') = '$este_mes'");
                              $quant_lancamentos_este_mes = mysqli_num_rows($result_es);
							  
							  $result_es = mysqli_query($conexao, "SELECT id FROM pagamentos_recebimentos WHERE tipo = '$tipo' AND 
							    DATE_FORMAT(data_pagamento_recebimento, '%d/%m/%Y') = '$ontem'");
                              $quant_lancamentos_ontem = mysqli_num_rows($result_es);
							  
							  $result_es = mysqli_query($conexao, "SELECT id FROM pagamentos_recebimentos WHERE tipo = '$tipo' AND 
							    DATE_FORMAT(data_pagamento_recebimento, '%d/%m/%Y') = '$hoje'");
                              $quant_lancamentos_hoje = mysqli_num_rows($result_es);
							  
							  echo '<div style="margin-bottom: 10px; color: #546e7a"><span style="font-size: 100%">No total h&aacute; <b>' . $quant_lancamentos . '</b> lan&ccedil;amentos de ' . (($tipo == "1") ? 'pagamentos' : 'recebimentos') . ' no sistema.</div>';
							  
							  echo '<div class="row">';
							    echo '<div class="col-xl-4">';
							       echo '<div style="font-size: 300%"><b>' . $quant_lancamentos_ano_passado . '</b></div><div style="border-top: 1px solid #bdbdbd">no <a href="' . $link_ano_passado . '">ano passado</a> (' . $ano_passado . ').</div>';  
                                echo '</div>';
							    
								echo '<div class="col-xl-4">';
							       echo '<div style="font-size: 300%"><b>' . $quant_lancamentos_este_ano . '</b></div><div style="border-top: 1px solid #bdbdbd"><a href="' . $link_este_ano . '">neste ano</a> (' . $este_ano . ').</div>';  
                                echo '</div>';
							  
							    echo '<div class="col-xl-4">';
							       echo '<div style="font-size: 300%"><b>' . $quant_lancamentos_mes_passado . '</b></div><div style="border-top: 1px solid #bdbdbd">no <a href="' . $link_mes_passado . '">m&ecirc;s passado</a> (' . $mes_passado . ').</div>';  
                                echo '</div>';
								
								echo '<div class="col-xl-4">';
							       echo '<div style="font-size: 300%"><b>' . $quant_lancamentos_este_mes . '</b></div><div style="border-top: 1px solid #bdbdbd"><a href="' . $link_este_mes . '">neste m&ecirc;s</a> (' . $este_mes . ').</div>';  
                                echo '</div>';
							  
							    echo '<div class="col-xl-4">';
							       echo '<div style="font-size: 300%"><b>' . $quant_lancamentos_ontem . '</b></div><div style="border-top: 1px solid #bdbdbd"><a href="' . $link_ontem . '">ontem</a> (' . $ontem . ').</div>';  
                                echo '</div>';
								
								echo '<div class="col-xl-4">';
							       echo '<div style="font-size: 300%"><b>' . $quant_lancamentos_hoje . '</b></div><div style="border-top: 1px solid #bdbdbd"><a href="' . $link_hoje . '">hoje</a> (' . $hoje . ').</div>';  
                                echo '</div>';
							echo '</div>';
							?>
                                    
                                  
                                </div>
                            </div>
                        </div>
                        
                        <!-- fim estatisticas de receitas e despesas //-->
                        
                    </div>
                </main>
                
                <?php require("rodape.php"); ?>
                
            </div>
        </div>
        <script src="bootstrap-5.0.2/js/bootstrap.bundle.min.js" crossorigin="anonymous"></script>
        <script src="js/scripts.js"></script>
        <script src="js/chart.js"></script>
    
    <?php
	     // rotina para constuir o grfico de receitas e despesas dos ltimos 6 meses
		 $meses_recebimentos = "";
         $valores_recebimentos = "";
         $valores_pagamentos = "";
         for($i = 7; $i >= 0; $i--){
	        $soma = 0;
	        $mes = mktime(0, 0, 0, date("m") - $i, date("d"), date("Y"));
	        $mes = date("m/Y", $mes);
	
	        // receitas
	        $sql = mysqli_query($conexao, "SELECT SUM((valor + acrescimo) - abatimento) AS total FROM pagamentos_recebimentos WHERE tipo = '2' 
	           AND DATE_FORMAT(data_pagamento_recebimento, '%m/%Y') = '$mes'");
            $linha = mysqli_fetch_array($sql);
            $soma = $soma + $linha['total'];
	        $meses_recebimentos = $meses_recebimentos . "'" . $mes . "', ";
	        $valores_recebimentos = $valores_recebimentos . $soma . ", ";
	
	        // despesas
	        $soma = 0;
	        $sql = mysqli_query($conexao, "SELECT SUM((valor + acrescimo) - abatimento) AS total FROM pagamentos_recebimentos WHERE tipo = '1' 
	           AND DATE_FORMAT(data_pagamento_recebimento, '%m/%Y') = '$mes'");
            $linha = mysqli_fetch_array($sql);
            $soma = $soma + $linha['total'];
	        $valores_pagamentos = $valores_pagamentos . $soma . ", ";	 
         }
		 // fim rotina para construir o grfico de receitas e despesas dos ltimos 6 meses
		 
		 // rotina para constuir o grfico de contas a pagar e a receber
		 $meses_receber = "";
         $valores_receber = "";
         $valores_pagar = "";
         for($i = 0; $i <= 7; $i++){
	        $soma = 0;
	        $mes = mktime(0, 0, 0, date("m") + $i, date("d"), date("Y"));
	        $mes = date("m/Y", $mes);
	
	        // a receber
	        $sql = mysqli_query($conexao, "SELECT SUM(valor) AS total FROM contas_pagar_receber WHERE tipo = '2' 
	           AND DATE_FORMAT(vencimento, '%m/%Y') = '$mes'");
            $linha = mysqli_fetch_array($sql);
            $soma = $soma + $linha['total'];
	        $meses_receber = $meses_receber . "'" . $mes . "', ";
	        $valores_receber = $valores_receber . $soma . ", ";
	
	        // a pagar
	        $soma = 0;
	        $sql = mysqli_query($conexao, "SELECT SUM(valor) AS total FROM contas_pagar_receber WHERE tipo = '1' 
	           AND DATE_FORMAT(vencimento, '%m/%Y') = '$mes'");
            $linha = mysqli_fetch_array($sql);
            $soma = $soma + $linha['total'];
	        $valores_pagar = $valores_pagar . $soma . ", ";	 
         }
		 // fim rotina para construir o grfico de contas a pagar e a receber
	   ?>
    
    <script type="text/javascript">
	   function exibir_chart_receitas_despesas(){
	     const labels = [<?= $meses_recebimentos ?>];
         const data = {
           labels: labels,
           datasets: [{
             label: 'Receitas',
             backgroundColor: '#2e7d32',
             borderColor: '#2e7d32',
             data: [<?= $valores_recebimentos ?>],
           },
		   {
             label: 'Despesas',
             backgroundColor: '#f44336',
             borderColor: '#f44336',
             data: [<?= $valores_pagamentos ?>],
           }]
         };
	   
	     const config = {
           type: 'line',
           data: data,
             options: {}
         };

         var grafico = new Chart(
           document.getElementById('chart_receitas_despesas'), config
         );
	   }
	   
	   function exibir_chart_pagar_receber(){
	     const labels = [<?= $meses_receber ?>];
         const data = {
           labels: labels,
           datasets: [{
             label: 'A Receber',
             backgroundColor: '#2e7d32',
             borderColor: '#2e7d32',
             data: [<?= $valores_receber ?>],
           },
		   {
             label: 'A Pagar',
             backgroundColor: '#f44336',
             borderColor: '#f44336',
             data: [<?= $valores_pagar ?>],
           }]
         };
	   
	     const config = {
           type: 'line',
           data: data,
             options: {}
         };

         var grafico = new Chart(
           document.getElementById('chart_pagar_receber'), config
         );
	   }

       exibir_chart_receitas_despesas();
	   exibir_chart_pagar_receber();
	</script>
    
    </body>
</html>

