<?php
  session_start();
  require("config.php");
  // o usuário está logado?
  if(!isset($_SESSION["id_usuario_logado"])){
    header("Location: login.php");
    exit;
  }
  
  $cliente_fornecedor = 0;
  if(isset($_GET["cliente_fornecedor"])){
	$cliente_fornecedor = tratar_entrada(utf8_decode(trim($_GET["cliente_fornecedor"])));  
  }
  
  $tipo = (int)($_GET["tipo"]);
?>
<!DOCTYPE html>
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-2" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge" />
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
  <meta name="description" content="" />
  <meta name="author" content="" />
  <title><?= $titulo_aplicacao ?> - Nova Conta a <?= ($tipo == "1") ? 'Pagar' : 'Receber' ?></title>
  <link rel="stylesheet" href="bootstrap-icons-1.5.0/font/bootstrap-icons.css" />
  <link href="css/styles.css?<?= date('Y-m-d_H:i:s'); ?>" rel="stylesheet" />
  <link rel="stylesheet" href="css/classic.css">
  <link rel="stylesheet" href="css/classic.date.css">
  
  <script src="js/jquery.min.js"></script>
  <script src="font-awesome/js/all.min.js" crossorigin="anonymous"></script>
  
  <style type="text/css">
    a{text-decoration:none} 
    .has-search .form-control {
    padding-left: 2.375rem;
    }

   .has-search .form-control-feedback {
    position: absolute;
    z-index: 2;
    display: block;
    width: 2.375rem;
    height: 2.375rem;
    line-height: 2.375rem;
    text-align: center;
    pointer-events: none;
    color: #aaa;
}

.blue-text {
    color: #00BCD4
}

.form-control-label {
    margin-bottom: 0
}

input,
textarea,
button {
    padding: 8px 15px;
    border-radius: 5px !important;
    margin: 5px 0px;
    box-sizing: border-box;
    border: 1px solid #ccc;
    font-size: 18px !important;
    font-weight: 300
}

input:focus,
textarea:focus {
    -moz-box-shadow: none !important;
    -webkit-box-shadow: none !important;
    box-shadow: none !important;
    border: 1px solid #00BCD4;
    outline-width: 0;
    font-weight: 400
}

.btn-block {
    text-transform: uppercase;
    font-size: 15px !important;
    font-weight: 400;
    height: 43px;
    cursor: pointer
}

.btn-block:hover {
    color: #fff !important
}

button:focus {
    -moz-box-shadow: none !important;
    -webkit-box-shadow: none !important;
    box-shadow: none !important;
    outline-width: 0
}

.image_area {
		  position: relative;
		}

		img {
		  	display: block;
		  	max-width: 100%;
		}

		.preview {
  			overflow: hidden;
  			width: 160px; 
  			height: 160px;
  			margin: 10px;
  			border: 1px solid red;
		}

		.modal-lg{
  			max-width: 1000px !important;
		}

		.overlay {
		  position: absolute;
		  bottom: 10px;
		  left: 0;
		  right: 0;
		  background-color: rgba(255, 255, 255, 0.5);
		  overflow: hidden;
		  height: 0;
		  transition: .5s ease;
		  width: 100%;
		}

		.image_area:hover .overlay {
		  height: 50%;
		  cursor: pointer;
		}

		.text {
		  color: #333;
		  font-size: 20px;
		  position: absolute;
		  top: 50%;
		  left: 50%;
		  -webkit-transform: translate(-50%, -50%);
		  -ms-transform: translate(-50%, -50%);
		  transform: translate(-50%, -50%);
		  text-align: center;
		}

  </style>
</head>

<body class="sb-nav-fixed">

<?php require("cima.php"); ?>

<div id="layoutSidenav">
            
            <?php require("menu_lado.php"); ?>
            
            <div id="layoutSidenav_content">
                <main>
                    <div class="container-fluid px-4">
                        
                        <h1 class="mt-4"><i class="bi-clipboard-plus"></i> Nova Conta a <?= ($tipo == "1") ? 'Pagar' : 'Receber' ?></h1>
                        
                        <ol class="breadcrumb mb-4">
                            <li class="breadcrumb-item"><a href="index.php">P&aacute;gina Inicial</a></li>
                            <li class="breadcrumb-item active">Nova Conta a <?= ($tipo == "1") ? 'Pagar' : 'Receber' ?></li>
                        </ol>
                        
                        <?php if(isset($_GET["sucesso"])){ ?>
						
                        <div class="alert alert-success" role="alert">
                          A Conta a <?= ($tipo == "1") ? 'Pagar' : 'Receber' ?> foi cadastrada com sucesso. Voce pode agora verificar as <a href="contas_pagar_receber.php?tipo=<?= $tipo ?>" class="alert-link">
                           <?= ($tipo == "1") ? ' Contas a Pagar' : ' Contas a Receber ' ?> cadastradas</a> ou continuar cadastrando mais <?= ($tipo == "1") ? ' contas' : 'contas' ?>.
                         </div>
                         
                        <?php } ?>
						
                        <div class="row">
                            <div class="col-xl-8">
                                <div class="card mb-4">
                                    <div class="card-header">
                                        <i class="bi-clipboard-data"></i>
                                        Dados da Nova Conta a <?= ($tipo == "1") ? 'Pagar' : 'Receber' ?>
                                    </div>
                                    <div class="card-body">
                                    
                                    <form id="cadastro_conta_pagar_receber" name="cadastro_conta_pagar_receber" action="cadastrar_conta_pagar_receber_action.php" method="post" class="form-card">
                                    
                                    <div class="row justify-content-between text-left">
                                       <div class="form-group col-12 flex-column d-flex">
                                       <label style="padding-left: 5px" class="form-control-label">Cliente/Fornecedor<span class="text-danger"> *</span></label>
                                          <select name="id_cliente_fornecedor" id="id_cliente_fornecedor" style="margin-bottom: 10px; margin-top: 10px" class="form-select">
                                             <option selected value="0">NAO SE APLICA</option>
											 <?php
											   $result = mysqli_query($conexao, "SELECT id, fantasia from clientes_fornecedores ORDER BY fantasia");
                                               if($result){
	                                              while($detalhes = mysqli_fetch_array($result)){
	                                                 $id_cliente_fornecedor = utf8_encode($detalhes["id"]);
	                                                 $nome_cliente_fornecedor = utf8_encode($detalhes["fantasia"]);
													 if($id_cliente_fornecedor == $cliente_fornecedor){
													   echo '<option selected value="' . $id_cliente_fornecedor . '">' . $nome_cliente_fornecedor . '</option>';
													 }
													 else{
													   echo '<option value="' . $id_cliente_fornecedor . '">' . $nome_cliente_fornecedor . '</option>';	 
													 }
												  }
											   }
											 ?>
                                          </select>
                                       </div>
                                    </div>
                                    
                                    <div class="row justify-content-between text-left">
                                       <div class="form-group col-12 flex-column d-flex">
                                          <label style="padding-left: 5px" class="form-control-label">Descriçao da Conta<span class="text-danger"> *</span></label>
                                          <textarea required class="form-control" onBlur="this.value = this.value.toUpperCase();" name="descricao" id="descricao" rows="3"></textarea>
                                       </div>
                                    </div>
                                    
                                    <div class="row justify-content-between text-left">
                                       <div class="form-group col-12 flex-column d-flex">
                                       <label style="padding-left: 5px" class="form-control-label">Plano de Contas<span class="text-danger"> *</span></label>
                                          <select name="plano" id="plano" style="margin-bottom: 10px; margin-top: 10px" class="form-select">
                                             <?php
											   $result = mysqli_query($conexao, "SELECT id, nome from plano_contas WHERE id_tipo_conta = '$tipo'");
                                               if($result){
	                                              while($detalhes = mysqli_fetch_array($result)){
	                                                 $id_plano_conta = utf8_encode($detalhes["id"]);
	                                                 $nome_plano_conta = utf8_encode($detalhes["nome"]);
													 echo '<option value="' . $id_plano_conta . '">' . $nome_plano_conta . '</option>';
												  }
											   }
											 ?>
                                          </select>
                                       </div>
                                    </div>
                                    
                                    <div class="row justify-content-between text-left">    
                                        <div class="form-group col-sm-6 flex-column d-flex">
                                         <label style="padding-left: 5px" class="form-control-label">Valor<span 
                                           class="text-danger"> *</span></label>
                                         <input type="text" name="valor" required id="valor" style="text-align: right;">
                                        </div>
                                        <div class="form-group col-sm-6 flex-column d-flex">
                                          <label style="padding-left: 5px" class="form-control-label">Vencimento<span class="text-danger"> *</span></label>
                                         <input type="text" style="margin-bottom: 10px; margin-top: 10px" required class="form-control" value="<?= date('d/m/Y') ?>" name="vencimento" id="vencimento" placeholder="Escolha a data"> 
                                       </div>
                                    </div>
                                    
                                    <div class="row justify-content-between text-left">
                                       <div class="form-group col-12 flex-column d-flex">
                                          <table style="margin-top: 7px; margin-bottom: 7px">
                                          <tr><td width="2%"><input class="form-check-input" type="checkbox" name="repete" value="S" id="repete"></td>
                                          <td>
										  <label style="padding-left: 5px" class="form-control-label"><?= ($tipo == "1") ? 'Esta conta se repete?' : 'Esta conta se repete?' ?></label></td></tr></table>
                                          
                                       </div>
                                    </div>
                                    
                                    <div id="div_repete" style="display: none">
                                    <div class="row justify-content-between text-left">    
                                        <div class="form-group col-sm-6 flex-column d-flex">
                                         <label style="padding-left: 5px" class="form-control-label">Quant Parcelas/Mensalidades<span 
                                           class="text-danger"> *</span></label>
                                         <input type="number" min="1" name="quantidade" value="1" required id="quantidade" style="text-align: right;">
                                        </div>
                                        <div class="form-group col-sm-6 flex-column d-flex">
                                          <label style="padding-left: 5px" class="form-control-label">Frequ&ecirc;ncia de Repeti&ccedil;&atilde;o<span class="text-danger"> *</span></label>
                                         <select name="frequencia" id="frequencia" style="margin-bottom: 10px; margin-top: 10px" class="form-select">
                                             <option selected value="mensal">MENSAL</option>
                                             <option value="anual">ANUAL</option>
                                             <option value="semanal">SEMANAL</option>
                                             <option value="quinzenal">QUINZENAL</option>
                                             <option value="diario">DIARIO</option>
                                          </select> 
                                       </div>
                                    </div>
                                    </div>
                                    
                                    <div class="row justify-content-end">
                                       <div class="form-group col-12 flex-column d-flex">
                                          <button type="submit" name="gravar" style="width: 200px" class="btn-block btn-secondary">Gravar Dados</button>
                                          <input type="hidden" name="tipo" id="tipo" value="<?= $tipo ?>">
                                       </div>
                                    </div>
                                    
                                    </form>
                                    
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-4">
                                <div class="card mb-4">
                                    <div class="card-header">
                                        <i class="bi-lightbulb"></i>
                                        Dica do Sistema
                                    </div>
                                    <div class="card-body">
                                    
                                    O nome do cliente ou fornecedor da conta a pagar ou a receber pode ser informado no momento do cadastro ou mais tarde, durante a edi&ccedil;&atilde;o do cadastro.
                                    
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        
                    </div>
                </main>
                
                <?php require("rodape.php"); ?>
                
            </div>
        
        <script src="bootstrap-5.0.2/js/bootstrap.bundle.min.js" crossorigin="anonymous"></script>
        <script src="js/scripts.js"></script>
        <script src="js/jquery.mask.min.js"></script>
    
    <script type="text/javascript">
	   $(document).ready(function(){
	     // trata a formataao dos campos
	     $('#valor').mask('000.000.000.000.000,00', {reverse: true});
	     // fim formataao dos campos
	   });
	</script>
    
    <script src="js/popper.min.js"></script>
        <script src="js/picker.js"></script>
        <script src="js/picker.date.js"></script>
        
        <script type="text/javascript">
		  $(function() {
             $('#vencimento').pickadate({
			    today: 'Hoje',
                clear: 'Limpar',
                close: 'Cancelar',
				weekdaysShort: ['D', 'S', 'T', 'Q', 'Q', 'S', 'S'],
                showMonthsShort: true,
				format: 'dd/mm/yyyy',
				formatSubmit: 'yyyy-mm-dd',
                hiddenName: true,
				labelMonthNext: 'Pr&oacute;ximo M&ecirc;s',
                labelMonthPrev: 'M&ecirc;s Anterior',
                labelMonthSelect: 'Selecione o M&ecirc;s',
                labelYearSelect: 'Selecione um Ano',
				monthsFull: ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'],
                monthsShort: ['Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set', 'Out', 'Nov', 'Dez'],
                weekdaysFull: ['Domingo', 'Segunda', 'Ter&ccedil;a', 'Quarta', 'Quinta', 'Sexta', 'S&aacute;bado'] 
			 });
          });
		  
		  $('#repete').change(function(){
            if($(this).is(':checked')){
               $('#div_repete').show();
            } 
			else{
			   $('#div_repete').hide();	
			}
          });
    </script>
    
    </body>
</html>

