<?php
  session_start();
  require("config.php");
  // o usuário está logado?
  if(!isset($_SESSION["id_usuario_logado"])){
    header("Location: login.php");
    exit;
  }
  
  $id_unico_pagamento_recebimento = time();
  $tipo = (int)($_GET["tipo"]);
  
  // a requisi�ao est� vindo da confirma�ao de uma conta a pagar ou a receber?
  $id_pagamento_recebimento = 0;
  $descricao = "";
  $valor = "";
  $plano = 0;
  $cliente_fornecedor = 0;
  
  if(isset($_GET["cliente_fornecedor"])){
	$cliente_fornecedor = tratar_entrada(utf8_decode(trim($_GET["cliente_fornecedor"])));  
  }
  
  if(isset($_GET["id_pagamento_recebimento"])){
	$id_pagamento_recebimento = (int)$_GET["id_pagamento_recebimento"];
    $result = mysqli_query($conexao, "select id_plano, descricao, valor, id_cliente_fornecedor from contas_pagar_receber WHERE id = '$id_pagamento_recebimento'");
    if($result){
	  while($detalhes = mysqli_fetch_array($result)){
	     $descricao = utf8_encode($detalhes["descricao"]);
	     $plano = $detalhes["id_plano"];
		 $cliente_fornecedor = $detalhes["id_cliente_fornecedor"];
	     $valor = number_format($detalhes["valor"], 2, ',', '.');
	  }
    }  
  }
  // fim a requisi�ao est� vindo da confirma�ao de uma conta a pagar ou a receber?
?>
<!DOCTYPE html>
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-2" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge" />
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
  <meta name="description" content="" />
  <meta name="author" content="" />
  <title><?= $titulo_aplicacao ?> - Novo <?= ($tipo == "1") ? 'Pagamento' : 'Recebimento' ?></title>
  <link rel="stylesheet" href="bootstrap-icons-1.5.0/font/bootstrap-icons.css" />
  <link href="css/styles.css?<?= date('Y-m-d_H:i:s'); ?>" rel="stylesheet" />
  <link rel="stylesheet" href="css/classic.css">
  <link rel="stylesheet" href="css/classic.date.css">
  
  <script src="js/jquery.min.js"></script>
  <script src="font-awesome/js/all.min.js" crossorigin="anonymous"></script>
  
  <style type="text/css">
    a{text-decoration:none} 
    .has-search .form-control {
    padding-left: 2.375rem;
    }

   .has-search .form-control-feedback {
    position: absolute;
    z-index: 2;
    display: block;
    width: 2.375rem;
    height: 2.375rem;
    line-height: 2.375rem;
    text-align: center;
    pointer-events: none;
    color: #aaa;
}

.blue-text {
    color: #00BCD4
}

.form-control-label {
    margin-bottom: 0
}

input,
textarea,
button {
    padding: 8px 15px;
    border-radius: 5px !important;
    margin: 5px 0px;
    box-sizing: border-box;
    border: 1px solid #ccc;
    font-size: 18px !important;
    font-weight: 300
}

input:focus,
textarea:focus {
    -moz-box-shadow: none !important;
    -webkit-box-shadow: none !important;
    box-shadow: none !important;
    border: 1px solid #00BCD4;
    outline-width: 0;
    font-weight: 400
}

.btn-block {
    text-transform: uppercase;
    font-size: 15px !important;
    font-weight: 400;
    height: 43px;
    cursor: pointer
}

.btn-block:hover {
    color: #fff !important
}

button:focus {
    -moz-box-shadow: none !important;
    -webkit-box-shadow: none !important;
    box-shadow: none !important;
    outline-width: 0
}

.image_area {
		  position: relative;
		}

		img {
		  	display: block;
		  	max-width: 100%;
		}

		.preview {
  			overflow: hidden;
  			width: 160px; 
  			height: 160px;
  			margin: 10px;
  			border: 1px solid red;
		}

		.modal-lg{
  			max-width: 1000px !important;
		}

		.overlay {
		  position: absolute;
		  bottom: 10px;
		  left: 0;
		  right: 0;
		  background-color: rgba(255, 255, 255, 0.5);
		  overflow: hidden;
		  height: 0;
		  transition: .5s ease;
		  width: 100%;
		}

		.image_area:hover .overlay {
		  height: 50%;
		  cursor: pointer;
		}

		.text {
		  color: #333;
		  font-size: 20px;
		  position: absolute;
		  top: 50%;
		  left: 50%;
		  -webkit-transform: translate(-50%, -50%);
		  -ms-transform: translate(-50%, -50%);
		  transform: translate(-50%, -50%);
		  text-align: center;
		}

  </style>
</head>

<body class="sb-nav-fixed">

<?php require("cima.php"); ?>

<div id="layoutSidenav">
            
            <?php require("menu_lado.php"); ?>
            
            <div id="layoutSidenav_content">
                <main>
                    <div class="container-fluid px-4">
                        
                        <h1 class="mt-4"><i class="bi-clipboard-plus"></i> Novo <?= ($tipo == "1") ? 'Pagamento' : 'Recebimento' ?></h1>
                        
                        <ol class="breadcrumb mb-4">
                            <li class="breadcrumb-item"><a href="index.php">P&aacute;gina Inicial</a></li>
                            <li class="breadcrumb-item active">Novo <?= ($tipo == "1") ? 'Pagamento' : 'Recebimento' ?></li>
                        </ol>
                        
                        <?php if(isset($_GET["sucesso"])){ ?>
						
                        <div class="alert alert-success" role="alert">
                          O <?= ($tipo == "1") ? 'Pagamento' : 'Recebimento' ?> foi cadastrado com sucesso. Voce pode agora verificar os <a href="pagamentos_recebimentos.php?tipo=<?= $tipo ?>" class="alert-link">
                           <?= ($tipo == "1") ? 'Pagamentos' : 'Recebimentos' ?> cadastrados</a> ou continuar cadastrando mais <?= ($tipo == "1") ? 'pagamentos' : 'recebimentos' ?>.
                         </div>
                         
                        <?php } ?>
						
                        <div class="row">
                            <div class="col-xl-8">
                                <div class="card mb-4">
                                    <div class="card-header">
                                        <i class="bi-clipboard-data"></i>
                                        Dados do Novo <?= ($tipo == "1") ? 'Pagamento' : 'Recebimento' ?>
                                    </div>
                                    <div class="card-body">
                                    
                                    <form id="cadastro_pagamento_recebimento" name="cadastro_pagamento_recebimento" action="cadastrar_pagamento_recebimento_action.php" method="post" class="form-card">
                                    
                                    <div class="row justify-content-between text-left">
                                       <div class="form-group col-12 flex-column d-flex">
                                       <label style="padding-left: 5px" class="form-control-label">Cliente/Fornecedor<span class="text-danger"> *</span></label>
                                          <select name="id_cliente_fornecedor" id="id_cliente_fornecedor" style="margin-bottom: 10px; margin-top: 10px" class="form-select">
                                             <option selected value="0">NAO SE APLICA</option>
											 <?php
											   $result = mysqli_query($conexao, "SELECT id, fantasia from clientes_fornecedores ORDER BY fantasia");
                                               if($result){
	                                              while($detalhes = mysqli_fetch_array($result)){
	                                                 $id_cliente_fornecedor = utf8_encode($detalhes["id"]);
	                                                 $nome_cliente_fornecedor = utf8_encode($detalhes["fantasia"]);
													 if($id_cliente_fornecedor == $cliente_fornecedor){
													   echo '<option selected value="' . $id_cliente_fornecedor . '">' . $nome_cliente_fornecedor 
													     . '</option>';
													 }
													 else{
													   echo '<option value="' . $id_cliente_fornecedor . '">' . $nome_cliente_fornecedor . '</option>';	 
													 }
												  }
											   }
											 ?>
                                          </select>
                                       </div>
                                    </div>
                                    
                                    <div class="row justify-content-between text-left">
                                       <div class="form-group col-12 flex-column d-flex">
                                          <label style="padding-left: 5px" class="form-control-label">Descriçao do Lan&ccedil;amento<span class="text-danger"> *</span></label>
                                          <textarea required class="form-control" onBlur="this.value = this.value.toUpperCase();" name="descricao" id="descricao" rows="3"><?= $descricao ?></textarea>
                                       </div>
                                    </div>
                                    
                                    <div class="row justify-content-between text-left">
                                       <div class="form-group col-12 flex-column d-flex">
                                          <label style="padding-left: 5px" class="form-control-label"><i class="fas fa-paperclip"></i> Documentos [<a href="javascript:efetuar_upload()">Adicionar</a>]</label>
                                          <div style="border-radius: 5px; border: 1px solid #cfd8dc; padding: 10px; margin-top: 10px; margin-bottom: 10px" id="docs_pagamentos_recebimentos">
                                          
                                          </div>
                                       </div>
                                    </div>
                                    
                                    <div class="row justify-content-between text-left">    
                                        <div class="form-group col-sm-6 flex-column d-flex">
                                         <label style="padding-left: 5px" class="form-control-label">Valor<span 
                                           class="text-danger"> *</span></label>
                                         <input type="text" onKeyUp="atualizar_valor_total()" name="valor" value="<?= $valor ?>" required id="valor" style="text-align: right;">
                                        </div>
                                    
                                        <div class="form-group col-sm-6 flex-column d-flex">
                                         <label style="padding-left: 5px" class="form-control-label">Acr&eacute;scimos/Juros<span 
                                           class="text-danger"> *</span></label>
                                         <input type="text" onKeyUp="atualizar_valor_total()" name="acrescimo" required id="acrescimo" value="0,00" style="text-align: right;">
                                       </div>
                                    </div>
                                    
                                    <div class="row justify-content-between text-left">    
                                        <div class="form-group col-sm-6 flex-column d-flex">
                                         <label style="padding-left: 5px" class="form-control-label">Abatimentos/Descontos<span 
                                           class="text-danger"> *</span></label>
                                         <input type="text" onKeyUp="atualizar_valor_total()" name="abatimento" required id="abatimento" value="0,00" style="text-align: right;">
                                        </div>
                                    
                                        <div class="form-group col-sm-6 flex-column d-flex">
                                         <label style="padding-left: 5px" class="form-control-label">Total<span 
                                           class="text-danger"> *</span></label>
                                         <input type="text" name="total" required id="total" disabled="disabled" value="0,00" style="text-align: right;">
                                       </div>
                                    </div>
                                    
                                    <div class="row justify-content-between text-left">
                                       <div class="form-group col-12 flex-column d-flex">
                                       <label style="padding-left: 5px" class="form-control-label">Plano de Contas<span class="text-danger"> *</span></label>
                                          <select name="plano" id="plano" style="margin-bottom: 10px; margin-top: 10px" class="form-select">
                                             <?php
											   $result = mysqli_query($conexao, "SELECT id, nome from plano_contas WHERE id_tipo_conta = '$tipo'");
                                               if($result){
	                                              while($detalhes = mysqli_fetch_array($result)){
	                                                 $id_plano_conta = utf8_encode($detalhes["id"]);
	                                                 $nome_plano_conta = utf8_encode($detalhes["nome"]);
													 if($id_plano_conta == $plano){
													   echo '<option selected value="' . $id_plano_conta . '">' . $nome_plano_conta . '</option>';
													 }
													 else{
													   echo '<option value="' . $id_plano_conta . '">' . $nome_plano_conta . '</option>';	 
													 }
												  }
											   }
											 ?>
                                          </select>
                                       </div>
                                    </div>
                                    
                                    <div class="row justify-content-between text-left">
                                       <div class="form-group col-12 flex-column d-flex">
                                       <label style="padding-left: 5px" class="form-control-label">Forma de <?= ($tipo == "1") ? 'Pagamento' : 'Recebimento' ?><span class="text-danger"> *</span></label>
                                          <select name="forma_pagamento_recebimento" id="forma_pagamento_recebimento" style="margin-bottom: 10px; margin-top: 10px" class="form-select">
                                             <?php
											   $result = mysqli_query($conexao, "SELECT id, nome from formas_pagamento_recebimento WHERE tipo = '$tipo'");
                                               if($result){
	                                              while($detalhes = mysqli_fetch_array($result)){
	                                                 $id_forma_pagamento_recebimento = utf8_encode($detalhes["id"]);
	                                                 $nome_forma_pagamento_recebimento = utf8_encode($detalhes["nome"]);
													 echo '<option value="' . $id_forma_pagamento_recebimento . '">' . $nome_forma_pagamento_recebimento . '</option>';
												  }
											   }
											 ?>
                                          </select>
                                       </div>
                                    </div>
                                    
                                    <div class="row justify-content-between text-left">
                                       <div class="form-group col-12 flex-column d-flex">
                                       <label style="padding-left: 5px" class="form-control-label">Atualizar Saldo<span class="text-danger"> *</span></label>
                                          <select name="conta_saldo" id="conta_saldo" style="margin-bottom: 10px; margin-top: 10px" class="form-select">
                                             <?php
											   $result = mysqli_query($conexao, "SELECT id, nome from contas_saldos ORDER BY nome");
                                               if($result){
	                                              while($detalhes = mysqli_fetch_array($result)){
	                                                 $id_conta_saldo = utf8_encode($detalhes["id"]);
	                                                 $nome_conta_saldo = utf8_encode($detalhes["nome"]);
													 echo '<option value="' . $id_conta_saldo . '">' . $nome_conta_saldo . '</option>';
												  }
											   }
											 ?>
                                          </select>
                                       </div>
                                    </div>
                                    
                                    <div class="row justify-content-between text-left">    
                                        <div class="form-group col-sm-6 flex-column d-flex">
                                          <label style="padding-left: 5px" class="form-control-label">Data do <?= ($tipo == "1") ? 'Pagamento' : 'Recebimento' ?><span class="text-danger"> *</span></label>
                                         <input type="text" style="margin-bottom: 10px; margin-top: 10px" required class="form-control" value="<?= date('d/m/Y') ?>" name="data_pagamento_recebimento" id="data_pagamento_recebimento" placeholder="Escolha a data"> 
                                       </div>
                                    </div>
                                    
                                    <div class="row justify-content-end">
                                       <div class="form-group col-12 flex-column d-flex">
                                          <button type="submit" name="gravar" style="width: 200px" class="btn-block btn-secondary">Gravar Dados</button>
                                          <input type="hidden" name="tipo" id="tipo" value="<?= $tipo ?>">
                                          <input type="hidden" name="id_unico_pagamento_recebimento" id="id_unico_pagamento_recebimento" value="<?= $id_unico_pagamento_recebimento ?>">
                                          <input id="arquivo" name="arquivo" type="file" style="display:none" onchange="enviar_arquivo(event)" accept="<?= $documentos_permitidos_elemento_file ?>">
                                          <input type="hidden" name="id_pagamento_recebimento" id="id_pagamento_recebimento" 
                                            value="<?= $id_pagamento_recebimento ?>">
                                          <input type="hidden" name="id_unico_pagamento_recebimento" id="id_unico_pagamento_recebimento" 
                                            value="<?= $id_unico_pagamento_recebimento ?>">   
                                       </div>
                                    </div>
                                    
                                    </form>
                                    
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-4">
                                <div class="card mb-4">
                                    <div class="card-header">
                                        <i class="bi-lightbulb"></i>
                                        Dica do Sistema
                                    </div>
                                    <div class="card-body">
                                    
                                    Ao cadastrar um novo pagamento ou recebimento voc&ecirc; pode optar por n&atilde;o informar de imediato o nome do cliente ou fornecedor, deixando essa informa&ccedil;&atilde;o para mais adiante. Voc&ecirc; pode tamb&eacute;m anexar documentos no momento do cadastro ou fazer a edi&ccedil;&atilde;o mais tarde.
                                    
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        
                    </div>
                    
                    <div id="janela_excluir_anexo" class="modal fade" role="dialog" style="width:100%">
    <div class="modal-dialog" style="width: 60%;">
        <div class="modal-content" >
            <div class="modal-header">Excluir</div>
            <div class="modal-body"><span id="msg_excluir3"></span></div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" onclick="confirmar_exclusao_anexo()">Confirmar</button>
                <button type="button" class="btn btn-secondary" onclick="fechar_exclusao_anexo()" data-dismiss="modal">Cancelar</button>
            </div>
        </div>
    </div>
    </div>
                    
                </main>
                
                <?php require("rodape.php"); ?>
                
            </div>
        
        <script src="bootstrap-5.0.2/js/bootstrap.bundle.min.js" crossorigin="anonymous"></script>
        <script src="js/scripts.js"></script>
        <script src="js/jquery.mask.min.js"></script>
    
    <script type="text/javascript">
	   var anexos = new Map();
	   var $modal_excluir_anexo = $('#janela_excluir_anexo');
       var id_exlusao = 0;
       var nome_anexo_exclusao;
       
	   $(document).ready(function(){
	     // trata a formata�ao dos campos
	     $('#valor').mask('000.000.000.000.000,00', {reverse: true});
		 $('#acrescimo').mask('000.000.000.000.000,00', {reverse: true});
		 $('#abatimento').mask('000.000.000.000.000,00', {reverse: true});
	     // fim formata�ao dos campos
	   });
	   
	   function atualizar_valor_total(){
		  var acrescimos = $('#acrescimo').val();
		  var descontos = $('#abatimento').val();
		  var valor = $('#valor').val();
		  
		  if(acrescimos.trim() == ""){
			return;  
		  }
		  if(valor.trim() == ""){
			return;  
		  }
		  if(descontos.trim() == ""){
			return;  
		  }
		  
		  valor = valor.replace(".", "");
		  valor = valor.replace(",", ".");
		  acrescimos = acrescimos.replace(".", "");
		  acrescimos = acrescimos.replace(",", ".");
		  descontos = descontos.replace(".", "");
		  descontos = descontos.replace(",", ".");
		  var valor_total = parseFloat(valor) + parseFloat(acrescimos) - parseFloat(descontos);
		  $('#total').val(valor_total.toLocaleString('pt-br', {minimumFractionDigits: 2}));	
		}
		
		function efetuar_upload(){
	      var arquivo = document.getElementById("arquivo");
          arquivo.click();  
        }
		
		function confirmar_exclusao_anexo(){
	       // vamos chamar um c�digo Ajax para excluir o arquivo, tanto na tabela de
		  // anexos quanto no diret�rio
		  var dados = {'nome_arquivo': nome_anexo_exclusao}

          $.ajax({
            url: 'excluir_documento_pagamento_recebimento_ajax.php',
            type: 'post',
            dataType: 'xml',
            data: dados,
            success: function(data){
			  anexos.delete(id_exclusao);
			  exibir_lista_anexos();
			  $modal_excluir_anexo.modal('hide');	
            },
            error: function(XMLHttpRequest, textStatus, errorThrown){
              window.alert('Houve um erro! Erro: ' + errorThrown.toString());
            }
          });
		  // fim chamar um c�digo Ajax para excluir o anexo	
	    }
		
		function excluir_anexo(id, anexo){
	      id_exclusao = id;
	      nome_anexo_exclusao = anexo;
	      $('#msg_excluir3').html("Voce deseja mesmo excluir o anexo <b>" + anexo + "</b>?");
	      $modal_excluir_anexo.modal('show');    
        }
	
        function fechar_exclusao_anexo(){
	       $modal_excluir_anexo.modal('hide');
        }
		
		function enviar_arquivo(event) {
	      var id_para_mensagem = "";
		  var id_unico_arquivo = Math.round(new Date().getTime()).toString(); 
          var id_arquivo_foto = "" + id_unico_arquivo + "_" + id_para_mensagem.toString();
          var fd = new FormData();
	      //  + "." + document.atualizar_atendimento.arquivo.value.split('.').pop()
          fd.append('fname', id_arquivo_foto + "_" + document.cadastro_pagamento_recebimento.arquivo.value.split('\\').pop());
          fd.append('arquivo', document.cadastro_pagamento_recebimento.arquivo.files[0]);
	      fd.append('id_pagamento_recebimento', '0');
		  fd.append('tipo', '<?= $tipo ?>');
		  fd.append('id_unico_pagamento_recebimento', '<?= $id_unico_pagamento_recebimento ?>');
          $.ajax({
            type: 'POST',
            url: 'enviar_documento_pagamento_recebimento_ajax.php',
            data: fd,
            processData: false,
            contentType: false
          }).done(function(data) {
            anexos.set(id_unico_arquivo, data);
			exibir_lista_anexos();
         });  
      }
	  
	  function exibir_lista_anexos(){
		var docs_pagamentos_recebimentos = document.getElementById("docs_pagamentos_recebimentos");
		docs_pagamentos_recebimentos.innerHTML = "";
		for (let [chave, valor] of anexos){
          docs_pagamentos_recebimentos.innerHTML = docs_pagamentos_recebimentos.innerHTML + '<div style="border-bottom: 1px solid #eceff1; padding-top: 5px; padding-bottom: 10px"><a target="_blank" href="<?= $url_documentos_pagamentos_recebimentos ?>/' + valor + '">' + valor + '</a> <a title="Clique para excluir" href="javascript:excluir_anexo(\'' + chave + '\', \'' + valor + '\')"><img style="display: inline" border="0" width="25px" src="imagens/excluir.gif"/></a></div>';
        }
	  }
	</script>
    
    <script src="js/popper.min.js"></script>
        <script src="js/picker.js"></script>
        <script src="js/picker.date.js"></script>
        
        <script type="text/javascript">
		  $(function() {
             $('#data_pagamento_recebimento').pickadate({
			    today: 'Hoje',
                clear: 'Limpar',
                close: 'Cancelar',
				weekdaysShort: ['D', 'S', 'T', 'Q', 'Q', 'S', 'S'],
                showMonthsShort: true,
				format: 'dd/mm/yyyy',
				formatSubmit: 'yyyy-mm-dd',
                hiddenName: true,
				labelMonthNext: 'Pr&oacute;ximo M&ecirc;s',
                labelMonthPrev: 'M&ecirc;s Anterior',
                labelMonthSelect: 'Selecione o M&ecirc;s',
                labelYearSelect: 'Selecione um Ano',
				monthsFull: ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'],
                monthsShort: ['Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set', 'Out', 'Nov', 'Dez'],
                weekdaysFull: ['Domingo', 'Segunda', 'Ter&ccedil;a', 'Quarta', 'Quinta', 'Sexta', 'S&aacute;bado'] 
			 });
          });
    </script>
    
    </body>
</html>

