<?php
  session_start();
  require("config.php");
  // o usuário está logado?
  if(!isset($_SESSION["id_usuario_logado"])){
    header("Location: login.php");
    exit;
  }
  
  $id_unico_pagamento_recebimento = time();
  
  // id do pagamento ou recebimeno a ser visualizado
  $id_pagamento_recebimento = (int)(trim($_GET["pagamento_recebimento"]));
  $tipo = (int)(trim($_GET["tipo"]));
  $result = mysqli_query($conexao, "select id, tipo, id_cliente_fornecedor, id_plano, id_forma_pagamento_recebimento, id_conta_saldo, descricao, valor, acrescimo, abatimento, DATE_FORMAT(data_pagamento_recebimento, '%d/%m/%Y') as data, DATE_FORMAT(data_cadastro, '%d/%m/%Y - %H:%i') as data_cadastro_lanc, usuario_cadastro from pagamentos_recebimentos WHERE id = '$id_pagamento_recebimento'");
  if($result){
	while($detalhes = mysqli_fetch_array($result)){
	   $tipo = utf8_encode($detalhes["tipo"]);
	   $cliente_fornecedor = utf8_encode($detalhes["id_cliente_fornecedor"]);
	   $descricao = utf8_encode($detalhes["descricao"]);
	   $plano = $detalhes["id_plano"];
	   $forma_pagamento_recebimento = $detalhes["id_forma_pagamento_recebimento"];
	   $conta_saldo = $detalhes["id_conta_saldo"];
	   $data = $detalhes["data"];
	   $valor = $detalhes["valor"];
	   $acrescimo = $detalhes["acrescimo"];
	   $abatimento = $detalhes["abatimento"];
	   $valor_total = ($valor + $acrescimo) - $abatimento; 
	   $data_cadastro = $detalhes["data_cadastro_lanc"];
	   $usuario_cadastro = utf8_encode($detalhes["usuario_cadastro"]);
	}
  }
  
  // vamos registrar esse log
  $ip = getUserIpAddr();
  $id_usuario_logado = $_SESSION["id_usuario_logado"];
  $usuario_logado = $_SESSION["usuario_logado"];
  $texto_log = 'O usuario ' . $usuario_logado . ' acessou o ' . (($tipo == "1") ? 'pagamento ' : 'recebimento ') . $descricao . '.';
  $result_2 = mysqli_query($conexao, "INSERT into logs values (null, '$id_usuario_logado', '$texto_log', 
    NOW(), '$usuario_logado', '$ip')");
  // fim registrar o log
?>
<!DOCTYPE html>
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-2" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge" />
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
  <meta name="description" content="" />
  <meta name="author" content="" />
  <title><?= $titulo_aplicacao ?> - <?= ($tipo == "1") ? 'Pagamento' : 'Recebimento' ?></title>
  <link rel="stylesheet" href="bootstrap-icons-1.5.0/font/bootstrap-icons.css" />
  <link href="css/styles.css?<?= date('Y-m-d_H:i:s'); ?>" rel="stylesheet" />
  <link rel="stylesheet" href="css/classic.css">
  <link rel="stylesheet" href="css/classic.date.css">
  
  <script src="js/jquery.min.js"></script>
  
  <script src="font-awesome/js/all.min.js" crossorigin="anonymous"></script>
  
  <style type="text/css">
    a{text-decoration:none} 
    .has-search .form-control {
    padding-left: 2.375rem;
    }

   .has-search .form-control-feedback {
    position: absolute;
    z-index: 2;
    display: block;
    width: 2.375rem;
    height: 2.375rem;
    line-height: 2.375rem;
    text-align: center;
    pointer-events: none;
    color: #aaa;
}

.blue-text {
    color: #00BCD4
}

.form-control-label {
    margin-bottom: 0
}

input,
textarea,
button {
    padding: 8px 15px;
    border-radius: 5px !important;
    margin: 5px 0px;
    box-sizing: border-box;
    border: 1px solid #ccc;
    font-size: 18px !important;
    font-weight: 300
}

input:focus,
textarea:focus {
    -moz-box-shadow: none !important;
    -webkit-box-shadow: none !important;
    box-shadow: none !important;
    border: 1px solid #00BCD4;
    outline-width: 0;
    font-weight: 400
}

.btn-block {
    text-transform: uppercase;
    font-size: 15px !important;
    font-weight: 400;
    height: 43px;
    cursor: pointer
}

.btn-block:hover {
    color: #fff !important
}

button:focus {
    -moz-box-shadow: none !important;
    -webkit-box-shadow: none !important;
    box-shadow: none !important;
    outline-width: 0
}

.image_area {
		  position: relative;
		}

		img {
		  	display: block;
		  	max-width: 100%;
		}

		.preview {
  			overflow: hidden;
  			width: 160px; 
  			height: 160px;
  			margin: 10px;
  			border: 1px solid red;
		}

		.modal-lg{
  			max-width: 1000px !important;
		}

		.overlay {
		  position: absolute;
		  bottom: 10px;
		  left: 0;
		  right: 0;
		  background-color: rgba(255, 255, 255, 0.5);
		  overflow: hidden;
		  height: 0;
		  transition: .5s ease;
		  width: 100%;
		}

		.image_area:hover .overlay {
		  height: 50%;
		  cursor: pointer;
		}

		.text {
		  color: #333;
		  font-size: 20px;
		  position: absolute;
		  top: 50%;
		  left: 50%;
		  -webkit-transform: translate(-50%, -50%);
		  -ms-transform: translate(-50%, -50%);
		  transform: translate(-50%, -50%);
		  text-align: center;
		}

  </style>
</head>

<body class="sb-nav-fixed">

<?php require("cima.php"); ?>

<div id="layoutSidenav">
           
           <?php require("menu_lado.php"); ?>
           
            <div id="layoutSidenav_content">
                <main>
                    <div class="container-fluid px-4">
                        
                        <h1 class="mt-4"><i class="bi-clipboard"></i> <?= ($tipo == "1") ? 'Pagamento' : 'Recebimento' ?></h1>
                        
                        <ol class="breadcrumb mb-4">
                            <li class="breadcrumb-item"><a href="index.php">P&aacute;gina Inicial</a></li>
                            <li class="breadcrumb-item active">Detalhes do <?= ($tipo == "1") ? 'Pagamento' : 'Recebimento' ?></li>
                        </ol>
                        
                        <?php if(isset($_GET["sucesso"])){ ?>
						
                        <div class="alert alert-success" role="alert">
                          O <?= ($tipo == "1") ? 'Pagamento' : 'Recebimento' ?> foi atualizado com sucesso.
                         </div>
                         
                        <?php } ?>
						
                        <div class="row">
                            <div class="col-xl-8">
                                <div class="card mb-4">
                                    <div class="card-header">
                                        <i class="bi-clipboard-data"></i>
                                        Dados do <?= ($tipo == "1") ? 'Pagamento' : 'Recebimento' ?>
                                    </div>
                                    <div class="card-body">
                                    
                                    <form id="cadastro_pagamento_recebimento" name="cadastro_pagamento_recebimento" action="atualizar_pagamento_recebimento_action.php" method="post" class="form-card">
                                    
                                    <?php
                                      if(isset($_GET["aba_pagamentos"])){ 
									   echo '<div style="padding-left: 4px; padding-bottom: 10px"><a href="cliente_fornecedor.php?aba_pagamentos=show&tipo=' . $_GET["tipo"] . '&cliente_fornecedor=' . $_GET["cliente_fornecedor"] . '"><i class="bi-arrow-left-circle-fill"></i> Voltar para a rela&ccedil;&atilde;o de pagamentos do cliente/fornecedor ' . $_GET["nome"] . '</a></div>';
									  }
									  else if(isset($_GET["aba_recebimentos"])){ 
									   echo '<div style="padding-left: 4px; padding-bottom: 10px"><a href="cliente_fornecedor.php?aba_recebimentos=show&tipo=' . $_GET["tipo"] . '&cliente_fornecedor=' . $_GET["cliente_fornecedor"] . '"><i class="bi-arrow-left-circle-fill"></i> Voltar para a rela&ccedil;&atilde;o de recebimentos do cliente/fornecedor ' . $_GET["nome"] . '</a></div>';
									  }
                                    ?>
                                    
                                    <div class="row justify-content-between text-left">
                                       <div class="form-group col-12 flex-column d-flex">
                                       <label style="padding-left: 5px" class="form-control-label">Cliente/Fornecedor<span class="text-danger"> *</span></label>
                                          <select name="id_cliente_fornecedor" id="id_cliente_fornecedor" style="margin-bottom: 10px; margin-top: 10px" class="form-select">
                                             <option selected value="0">NAO SE APLICA</option>
											 <?php
											   $result = mysqli_query($conexao, "SELECT id, fantasia from clientes_fornecedores ORDER BY fantasia");
                                               if($result){
	                                              while($detalhes = mysqli_fetch_array($result)){
	                                                 $id_cliente_fornecedor = utf8_encode($detalhes["id"]);
	                                                 $nome_cliente_fornecedor = utf8_encode($detalhes["fantasia"]);
													 if($id_cliente_fornecedor == $cliente_fornecedor){
													   echo '<option selected value="' . $id_cliente_fornecedor . '">' . $nome_cliente_fornecedor . '</option>';
													 }
													 else{
													   echo '<option value="' . $id_cliente_fornecedor . '">' . $nome_cliente_fornecedor . '</option>';	 
													 }
												  }
											   }
											 ?>
                                          </select>
                                       </div>
                                    </div>
                                       
                                    <div class="row justify-content-between text-left">
                                       <div class="form-group col-12 flex-column d-flex">
                                          <label style="padding-left: 5px" class="form-control-label">Descriçao do Lan&ccedil;amento<span class="text-danger"> *</span></label>
                                          <textarea required class="form-control" onBlur="this.value = this.value.toUpperCase();" name="descricao" id="descricao" rows="3"><?= $descricao ?></textarea>
                                       </div>
                                    </div>
                                    
                                    <div class="row justify-content-between text-left">
                                       <div class="form-group col-12 flex-column d-flex">
                                          <label style="padding-left: 5px" class="form-control-label"><i class="fas fa-paperclip"></i> Documentos [<a href="javascript:efetuar_upload()">Adicionar</a>]</label>
                                          <div style="border-radius: 5px; border: 1px solid #cfd8dc; padding: 10px; margin-top: 10px; margin-bottom: 10px" id="docs_pagamentos_recebimentos">
                                          
                                          </div>
                                       </div>
                                    </div>
                                    
                                    <div class="row justify-content-between text-left">    
                                        <div class="form-group col-sm-6 flex-column d-flex">
                                         <label style="padding-left: 5px" class="form-control-label">Valor<span 
                                           class="text-danger"> *</span></label>
                                         <input type="text" onKeyUp="atualizar_valor_total()" value="<?= number_format($valor, 2, ',', '.') ?>" name="valor" required id="valor" style="text-align: right;">
                                        </div>
                                    
                                        <div class="form-group col-sm-6 flex-column d-flex">
                                         <label style="padding-left: 5px" class="form-control-label">Acr&eacute;scimos/Juros<span 
                                           class="text-danger"> *</span></label>
                                         <input type="text" onKeyUp="atualizar_valor_total()" value="<?= number_format($acrescimo, 2, ',', '.') ?>" name="acrescimo" required id="acrescimo" style="text-align: right;">
                                       </div>
                                    </div>
                                    
                                    <div class="row justify-content-between text-left">    
                                        <div class="form-group col-sm-6 flex-column d-flex">
                                         <label style="padding-left: 5px" class="form-control-label">Abatimentos/Descontos<span 
                                           class="text-danger"> *</span></label>
                                         <input type="text" onKeyUp="atualizar_valor_total()" value="<?= number_format($abatimento, 2, ',', '.') ?>" name="abatimento" required id="abatimento" style="text-align: right;">
                                        </div>
                                    
                                        <div class="form-group col-sm-6 flex-column d-flex">
                                         <label style="padding-left: 5px" class="form-control-label">Total<span 
                                           class="text-danger"> *</span></label>
                                         <input type="text" name="total" required id="total" disabled="disabled" value="<?= number_format($valor_total, 2, ',', '.') ?>" style="text-align: right;">
                                       </div>
                                    </div>
                                    
                                    <div class="row justify-content-between text-left">
                                       <div class="form-group col-12 flex-column d-flex">
                                       <label style="padding-left: 5px" class="form-control-label">Plano de Contas<span class="text-danger"> *</span></label>
                                          <select name="plano" id="plano" style="margin-bottom: 10px; margin-top: 10px" class="form-select">
                                             <?php
											   $result = mysqli_query($conexao, "SELECT id, nome from plano_contas WHERE id_tipo_conta = '$tipo'");
                                               if($result){
	                                              while($detalhes = mysqli_fetch_array($result)){
	                                                 $id_plano_conta = utf8_encode($detalhes["id"]);
	                                                 $nome_plano_conta = utf8_encode($detalhes["nome"]);
													 if($id_plano_conta == $plano){
													    echo '<option selected value="' . $id_plano_conta . '">' . $nome_plano_conta . '</option>';
													 }
													 else{
														echo '<option value="' . $id_plano_conta . '">' . $nome_plano_conta . '</option>'; 
													 }
												  }
											   }
											 ?>
                                          </select>
                                       </div>
                                    </div>
                                    
                                    <div class="row justify-content-between text-left">
                                       <div class="form-group col-12 flex-column d-flex">
                                       <label style="padding-left: 5px" class="form-control-label">Forma de <?= ($tipo == "1") ? 'Pagamento' : 'Recebimento' ?><span class="text-danger"> *</span></label>
                                          <select name="forma_pagamento_recebimento" id="forma_pagamento_recebimento" style="margin-bottom: 10px; margin-top: 10px" class="form-select">
                                             <?php
											   $result = mysqli_query($conexao, "SELECT id, nome from formas_pagamento_recebimento WHERE tipo = '$tipo'");
                                               if($result){
	                                              while($detalhes = mysqli_fetch_array($result)){
	                                                 $id_forma_pagamento_recebimento = utf8_encode($detalhes["id"]);
	                                                 $nome_forma_pagamento_recebimento = utf8_encode($detalhes["nome"]);
													 if($id_forma_pagamento_recebimento == $forma_pagamento_recebimento){
													   echo '<option selected value="' . $id_forma_pagamento_recebimento . '">' . 
													      $nome_forma_pagamento_recebimento . '</option>';
													 }
													 else{
													    echo '<option value="' . $id_forma_pagamento_recebimento . '">' . 
													      $nome_forma_pagamento_recebimento . '</option>';	 
													 }
												  }
											   }
											 ?>
                                          </select>
                                       </div>
                                    </div>
                                       
                                    <div class="row justify-content-between text-left">
                                       <div class="form-group col-12 flex-column d-flex">
                                       <label style="padding-left: 5px" class="form-control-label">Atualizar Saldo<span class="text-danger"> *</span></label>
                                          <select name="conta_saldo" id="conta_saldo" style="margin-bottom: 10px; margin-top: 10px" class="form-select">
                                             <?php
											   $result = mysqli_query($conexao, "SELECT id, nome from contas_saldos ORDER BY nome");
                                               if($result){
	                                              while($detalhes = mysqli_fetch_array($result)){
	                                                 $id_conta_saldo = utf8_encode($detalhes["id"]);
	                                                 $nome_conta_saldo = utf8_encode($detalhes["nome"]);
													 if($id_conta_saldo == $conta_saldo){
													    echo '<option selected value="' . $id_conta_saldo . '">' . $nome_conta_saldo . '</option>';
													 }
													 else{
													    echo '<option value="' . $id_conta_saldo . '">' . $nome_conta_saldo . '</option>';
													 }
												  }
											   }
											 ?>
                                          </select>
                                       </div>
                                    </div>
                                    
                                    <div class="row justify-content-between text-left">    
                                        <div class="form-group col-sm-6 flex-column d-flex">
                                          <label style="padding-left: 5px" class="form-control-label">Data do <?= ($tipo == "1") ? 'Pagamento' : 'Recebimento' ?><span class="text-danger"> *</span></label>
                                         <input type="text" style="margin-bottom: 10px; margin-top: 10px" required class="form-control" value="<?= $data ?>" name="data_pagamento_recebimento" id="data_pagamento_recebimento" placeholder="Escolha a data"> 
                                       </div>
                                       <div class="form-group col-sm-6 flex-column d-flex">
                                         <label style="padding-left: 5px" class="form-control-label">C&oacute;digo Lan&ccedil;amento<span class="text-danger"> *</span></label>
                                         <input required type="text" disabled="disabled" id="codigo_lancamento" value="<?= $id_pagamento_recebimento ?>" name="codigo_lancamento" placeholder="">
                                       </div>
                                    </div>
                                       
                                    <div class="row justify-content-between text-left">
                                       <div class="form-group col-sm-6 flex-column d-flex">
                                         <label style="padding-left: 5px" class="form-control-label">Data de Cadastro<span class="text-danger"> *</span></label>
                                         <input required type="text" disabled="disabled" id="data_cadastro" value="<?= $data_cadastro ?>" name="data_cadastro" placeholder="">
                                       </div>
                                       
                                       <div class="form-group col-sm-6 flex-column d-flex">
                                           <label style="padding-left: 5px" class="form-control-label">Usu&aacute;rio Cadastro<span class="text-danger"> *</span></label>
                                         <input required type="text" disabled="disabled" id="usuario_cadastro" value="<?= obterNomeUsuarioId($usuario_cadastro) ?>" name="usuario_cadastro" placeholder="">
                                       </div>
                                    </div>
                                    
                                    <div class="row justify-content-end">
                                       <div class="form-group col-12 flex-column d-flex">
                                          <div class="btn-group" role="group">
                                            
                                            <?php if(Permissao::podeAlterar($_SESSION["nivel_acesso"])){ ?>
                                              <button type="submit" name="gravar" style="margin-right: 8px; width: 180px" 
                                              class="btn-secondary">Atualizar Dados</button>
                                            <?php } ?>
                                            
                                            <?php if(Permissao::podeExcluir($_SESSION["nivel_acesso"])){ ?>
                                              <button type="button" onclick="excluir_registro('<?= $id_pagamento_recebimento ?>', '<?= $descricao ?>')" 
                                              name="excluir" style="width: 180px" class="btn-secondary">Excluir</button>
                                            <?php } ?>
                                          
                                          </div>
                                          <input name="tipo" type="hidden" id="tipo" value="<?= $tipo ?>">
                                          <input name="id_pagamento_recebimento" type="hidden" id="id_pagamento_recebimento" 
                                          value="<?= $id_pagamento_recebimento ?>">
                                          <input name="conta_saldo_anterior" type="hidden" id="conta_saldo_anterior" value="<?= $conta_saldo ?>">
                                          <input name="total_anterior" type="hidden" id="total_anterior" value="<?= $valor_total ?>">
                                          <input id="arquivo" name="arquivo" type="file" style="display:none" onchange="enviar_arquivo(event)" accept="<?= $documentos_permitidos_elemento_file ?>">
                                       </div>
                                    </div>
                                    
                                    </form>
                                    
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-4">
                                <div class="card mb-4">
                                    <div class="card-header">
                                        <i class="bi-lightbulb"></i>
                                        Dica do Sistema
                                    </div>
                                    <div class="card-body">
                                    
                                    Voc&ecirc; pode inserir algum texto informativo ou de ajuda aqui. Isso tornar&aacute; o sistema mais f&aacute;cil de usar.
                                    
                                    </div>
                                </div>
                            </div>
                            </div>
                        </div>
                     
                </main>
                
                <?php require("rodape.php"); ?>
                
            </div>
        
        
        <div id="janela_excluir_anexo" class="modal fade" role="dialog" style="width:100%">
    <div class="modal-dialog" style="width: 60%;">
        <div class="modal-content" >
            <div class="modal-header">Excluir</div>
            <div class="modal-body"><span id="msg_excluir3"></span></div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" onclick="confirmar_exclusao_anexo()">Confirmar</button>
                <button type="button" class="btn btn-secondary" onclick="fechar_exclusao_anexo()" data-dismiss="modal">Cancelar</button>
            </div>
        </div>
    </div>
    </div>
        
        
        <div id="janela_excluir_forma_pagamento_recebimento" class="modal fade" role="dialog" style="width:100%">
    <div class="modal-dialog" style="width: 60%;">
        <div class="modal-content" >
            <div class="modal-header">Excluir</div>
            <div class="modal-body"><span id="msg_excluir"></span></div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" onclick="confirmar_exclusao()">Confirmar</button>
                <button type="button" class="btn btn-secondary" onclick="fechar_exclusao()" data-dismiss="modal">Cancelar</button>
            </div>
        </div>
    </div>
    </div>
        
        </div>
        <script src="bootstrap-5.0.2/js/bootstrap.bundle.min.js" crossorigin="anonymous"></script>
        <script src="js/scripts.js"></script>
    
    
    <script type="text/javascript">
  
  var anexos = new Map();
  var $modal_excluir = $('#janela_excluir_forma_pagamento_recebimento');
  var id_exlusao = 0;
  var descricao_lancamento_excluir;
  var $modal_excluir_anexo = $('#janela_excluir_anexo');
  var nome_anexo_exclusao;
  var id_anexo_exclusao;
     
  function excluir_registro(id, nome){
	id_exclusao = id;
	descricao_lancamento_excluir = nome;
	
	$('#msg_excluir').html("Voce deseja mesmo excluir o <?= ($tipo == "1") ? 'pagamento' : 'recebimento' ?> <b>" + nome + "</b>?<br><br>Esta operacao nao podera ser desfeita.");
	$modal_excluir.modal('show');    
  }
	   
  function confirmar_exclusao(){
	 var url_volta = 'pagamentos_recebimentos.php?tipo=<?= $tipo ?>';
     window.location = "excluir_pagamento_recebimento.php?tipo=<?= $tipo ?>&pagamento_recebimento=" + id_exclusao + "&descricao_lancamento_excluir=" + descricao_lancamento_excluir + "&volta=" + url_volta;    
  }
	   
  function fechar_exclusao(){
	 $modal_excluir.modal('hide');
  }
  
  function confirmar_exclusao_anexo(){
	// vamos chamar um cdigo Ajax para excluir o arquivo, tanto na tabela de
	// anexos quanto no diretrio
	var dados = {'nome_arquivo': nome_anexo_exclusao}

   $.ajax({
      url: 'excluir_documento_pagamento_recebimento_ajax.php',
      type: 'post',
      dataType: 'xml',
      data: dados,
      success: function(data){
		$modal_excluir_anexo.modal('hide');  
		anexos.delete(id_anexo_exclusao);
		exibir_lista_anexos();	
      },
      error: function(XMLHttpRequest, textStatus, errorThrown){
         window.alert('Houve um erro! Erro: ' + errorThrown.toString());
      }
    });
	// fim chamar um cdigo Ajax para excluir o anexo  
  }
  
  function excluir_anexo(id, anexo){
	id_anexo_exclusao = id;
	nome_anexo_exclusao = anexo;
	tipo_anexo = tipo;
	$('#msg_excluir3').html("Voce deseja mesmo excluir o anexo <b>" + anexo + "</b>?");
	$modal_excluir_anexo.modal('show');    
  }
	   
  function fechar_exclusao_anexo(){
	 $modal_excluir_anexo.modal('hide');
  }
  
  function enviar_arquivo(event) {
	 var id_para_mensagem = "";
	 var id_unico_arquivo = Math.round(new Date().getTime()).toString(); 
     var id_arquivo_foto = "" + id_unico_arquivo + "_" + id_para_mensagem.toString();
     var fd = new FormData();
	 fd.append('fname', id_arquivo_foto + "_" + document.cadastro_pagamento_recebimento.arquivo.value.split('\\').pop());
     fd.append('arquivo', document.cadastro_pagamento_recebimento.arquivo.files[0]);
	 fd.append('id_pagamento_recebimento', '<?= $id_pagamento_recebimento ?>');
	 fd.append('tipo', '<?= $tipo ?>');
	 fd.append('id_unico_pagamento_recebimento', '<?= $id_unico_pagamento_recebimento ?>');
     $.ajax({
        type: 'POST',
        url: 'enviar_documento_pagamento_recebimento_ajax.php',
        data: fd,
        processData: false,
        contentType: false
     }).done(function(data) {
        // mao precisa fazer nada
		anexos.set(id_unico_arquivo, data);
		exibir_lista_anexos();
     });
  }
  
  function exibir_lista_anexos(){
	var docs_pagamentos_recebimentos = document.getElementById("docs_pagamentos_recebimentos");
	docs_pagamentos_recebimentos.innerHTML = "";
	for (let [chave, valor] of anexos){
      docs_pagamentos_recebimentos.innerHTML = docs_pagamentos_recebimentos.innerHTML + '<div style="border-bottom: 1px solid #eceff1; padding-top: 5px; padding-bottom: 10px"><a target="_blank" href="<?= $url_documentos_pagamentos_recebimentos ?>/' + valor + '">' + valor + '</a> <a title="Clique para excluir" href="javascript:excluir_anexo(\'' + chave + '\', \'' + valor + '\')"><img style="display: inline" border="0" width="25px" src="imagens/excluir.gif"/></a></div>';
      }
  }
  
  <?php
	$result = mysqli_query($conexao, "select id, arquivo from anexos_pagamentos_recebimentos WHERE tipo = '$tipo'
		and id_pai = '$id_pagamento_recebimento' order by id asc");
	while($detalhes = mysqli_fetch_array($result)){
       $id_anexo = utf8_encode($detalhes["id"]);
	   $nome_anexo = nl2br(utf8_encode($detalhes["arquivo"]));
	   echo 'anexos.set(\'' . $id_anexo . '\', \'' . $nome_anexo . '\');' . "\n";
	}
  ?>
  
  function efetuar_upload(){
	 var arquivo = document.getElementById("arquivo");
     arquivo.click();  
  }
  </script>
  
  <script src="js/scripts.js"></script>
        <script src="js/jquery.mask.min.js"></script>
    
    <script type="text/javascript">
	   $(document).ready(function(){
	     // trata a formataao dos campos
	     $('#valor').mask('000.000.000.000.000,00', {reverse: true});
		 $('#acrescimo').mask('000.000.000.000.000,00', {reverse: true});
		 $('#abatimento').mask('000.000.000.000.000,00', {reverse: true});
	     // fim formataao dos campos
		 
		 exibir_lista_anexos(); 
	   });
	   
	   function atualizar_valor_total(){
		  var acrescimos = $('#acrescimo').val();
		  var descontos = $('#abatimento').val();
		  var valor = $('#valor').val();
		  
		  if(acrescimos.trim() == ""){
			return;  
		  }
		  if(valor.trim() == ""){
			return;  
		  }
		  if(descontos.trim() == ""){
			return;  
		  }
		  
		  valor = valor.replace(".", "");
		  valor = valor.replace(",", ".");
		  acrescimos = acrescimos.replace(".", "");
		  acrescimos = acrescimos.replace(",", ".");
		  descontos = descontos.replace(".", "");
		  descontos = descontos.replace(",", ".");
		  var valor_total = parseFloat(valor) + parseFloat(acrescimos) - parseFloat(descontos);
		  $('#total').val(valor_total.toLocaleString('pt-br', {minimumFractionDigits: 2}));	
		}
	</script>
    
    <script src="js/popper.min.js"></script>
        <script src="js/picker.js"></script>
        <script src="js/picker.date.js"></script>
        
        <script type="text/javascript">
		  $(function() {
             $('#data_pagamento_recebimento').pickadate({
			    today: 'Hoje',
                clear: 'Limpar',
                close: 'Cancelar',
				weekdaysShort: ['D', 'S', 'T', 'Q', 'Q', 'S', 'S'],
                showMonthsShort: true,
				format: 'dd/mm/yyyy',
				formatSubmit: 'yyyy-mm-dd',
                hiddenName: true,
				labelMonthNext: 'Pr&oacute;ximo M&ecirc;s',
                labelMonthPrev: 'M&ecirc;s Anterior',
                labelMonthSelect: 'Selecione o M&ecirc;s',
                labelYearSelect: 'Selecione um Ano',
				monthsFull: ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'],
                monthsShort: ['Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set', 'Out', 'Nov', 'Dez'],
                weekdaysFull: ['Domingo', 'Segunda', 'Ter&ccedil;a', 'Quarta', 'Quinta', 'Sexta', 'S&aacute;bado'] 
			 });
          });
    </script>
</script>
    
    
    </body>
</html>

