<?php
  session_start();
  require("config.php");
  // o usuário está logado?
  if(!isset($_SESSION["id_usuario_logado"])){
    header("Location: login.php");
    exit;
  }
  
  $tipo = (int)($_GET["tipo"]);
  
  // vamos registrar esse log
  $ip = getUserIpAddr();
  $id_usuario_logado = $_SESSION["id_usuario_logado"];
  $usuario_logado = $_SESSION["usuario_logado"];
  $texto_log = 'O usuario ' . $usuario_logado . ' acessou a relacao de ' . (($tipo == "1") ? 'Pagamentos' : 'Recebimentos') . ' do sistema.';
  $result_2 = mysqli_query($conexao, "INSERT into logs values (null, '$id_usuario_logado', '$texto_log', 
    NOW(), '$usuario_logado', '$ip')");
  // fim registrar o log
  
  // plano de contas e forma de pagamento
  $plano = -1;
  $plano_contas = ' (1 < 5) AND ';
  if(isset($_GET["plano"])){
	if($_GET["plano"] != '-1'){  
	  $plano_contas = ' id_plano = ' . (int)($_GET["plano"]) . ' AND ';
	  $plano = (int)($_GET["plano"]);
	}
  }
  $forma = -1;
  $forma_pagamento_recebimento = ' (1 < 5) AND ';
  if(isset($_GET["forma_pagamento_recebimento"])){
	if($_GET["forma_pagamento_recebimento"] != '-1'){  
	  $forma_pagamento_recebimento = ' id_forma_pagamento_recebimento = ' . (int)($_GET["forma_pagamento_recebimento"]) . ' AND ';
	  $forma = (int)($_GET["forma_pagamento_recebimento"]);
	}
  }
  
  // opoes de filtro e ordenaao
  $ordenacao = 'data_pagamento_recebimento';
  if(isset($_GET["ordem_por"])){
	$ordenacao = tratar_entrada($_GET["ordem_por"]);  
  }
  
  $per_page = 20;
  if(isset($_GET["quant_paginas"])){
	$per_page = tratar_entrada($_GET["quant_paginas"]);  
  }
  
  $ordem_class = 'desc';
  if(isset($_GET["ordem_class"])){
	$ordem_class = tratar_entrada($_GET["ordem_class"]);  
  }
  // fim opoes de filhtro e ordenaao
  
  if(isset($_GET["pesquisa"])){
	 $pesquisa_pagamentos_recebimentos = tratar_entrada(utf8_decode(trim($_GET["pesquisa"]))); 
     $sql_text = ("select id, id_cliente_fornecedor, tipo, descricao, DATE_FORMAT(data_pagamento_recebimento, '%d/%m/%Y') as data, DATE_FORMAT(data_cadastro, '%d/%m/%Y - %H:%i') as data_cadastro_lanc, valor, acrescimo, abatimento, usuario_cadastro from pagamentos_recebimentos WHERE tipo = '$tipo' AND descricao LIKE '%$pesquisa_pagamentos_recebimentos%' order by " . $ordenacao . " " . $ordem_class);
     $sql_text2 = ("select id FROM pagamentos_recebimentos WHERE tipo = '$tipo' AND descricao LIKE '%$pesquisa_pagamentos_recebimentos%'");
  }
  else{
	 $sql_text = ("select id, id_cliente_fornecedor, tipo, descricao, DATE_FORMAT(data_pagamento_recebimento, '%d/%m/%Y') as data, DATE_FORMAT(data_cadastro, '%d/%m/%Y - %H:%i') as data_cadastro_lanc, valor, acrescimo, abatimento, usuario_cadastro from pagamentos_recebimentos WHERE " . $plano_contas . $forma_pagamento_recebimento . " (data_pagamento_recebimento BETWEEN '$data_inicial' AND '$data_final') AND tipo = '$tipo' order by " . $ordenacao . " " . $ordem_class);
     $sql_text2 = ("select id from pagamentos_recebimentos");  
  }
		
  $sql_text2 = $sql_text;
  $query2 = mysqli_query($conexao, $sql_text2);
  $num_rows2 = mysqli_num_rows($query2);

  if(isset($_GET["page"])){ 
    $page = (int)$_GET["page"];
  }
  else{
	$page = 1;   
  }
  
  $pagesize = $per_page;
  
  $query = mysqli_query($conexao, $sql_text); 
  if(!isset($_GET["page"])) $page = 1;
  $prev_page = $page - 1;
  $next_page = $page + 1;
  $query = mysqli_query($conexao, $sql_text);
  $page_start = ($per_page * $page) - $per_page;
  $num_rows = mysqli_num_rows($query);
  if ($num_rows <= $per_page) $num_pages = 1;
  else if (($num_rows % $per_page) == 0) $num_pages = ($num_rows / $per_page);
  else $num_pages = ($num_rows / $per_page) + 1;
  $num_pages = (int) $num_pages; 
  $totoalPages = $num_pages;
  $sql_text = $sql_text . " LIMIT $page_start, $per_page";
  $resultado_paginacao = mysqli_query($conexao, $sql_text);
?>
<!DOCTYPE html>
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-2" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge" />
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
  <meta name="description" content="" />
  <meta name="author" content="" />
  <title><?= $titulo_aplicacao ?> - <?= ($tipo == "1") ? 'Pagamentos' : 'Recebimentos' ?></title>
  <link rel="stylesheet" href="bootstrap-icons-1.5.0/font/bootstrap-icons.css" />
  <link href="css/styles.css?<?= date('Y-m-d_H:i:s'); ?>" rel="stylesheet" />
  <link rel="stylesheet" href="css/classic.css">
  <link rel="stylesheet" href="css/classic.date.css">
  <script src="font-awesome/js/all.min.js" crossorigin="anonymous"></script>
  <script src="js/jquery.min.js"></script>
  
  <style type="text/css">
    a{text-decoration:none} 
    .has-search .form-control {
    padding-left: 2.375rem;
}

.has-search .form-control-feedback {
    position: absolute;
    z-index: 2;
    display: block;
    width: 2.375rem;
    height: 2.375rem;
    line-height: 2.375rem;
    text-align: center;
    pointer-events: none;
    color: #aaa;
}
  </style>
</head>

<body class="sb-nav-fixed">

<?php require("cima.php"); ?>

<div id="layoutSidenav">
            
            <?php require("menu_lado.php"); ?>
            
            <div id="layoutSidenav_content">
                <main>
                    <div class="container-fluid px-4">
                        
                        <h1 class="mt-4"><i class="bi-clipboard"></i> <?= ($tipo == "1") ? 'Pagamentos' : 'Recebimentos' ?></h1>
                        
                        <table width="100%">
                        <tr>
                        <td>
                        <ol class="breadcrumb mb-4">
                            <li class="breadcrumb-item"><a href="index.php">P&aacute;gina Inicial</a></li>
                            <li class="breadcrumb-item active"><?= ($tipo == "1") ? 'Pagamentos' : 'Recebimentos' ?></li>
                        </ol>
                        </td>
                        <td align="right"><?= (Permissao::podeCadastrar($_SESSION["nivel_acesso"]) ? '<a href="novo_pagamento_recebimento.php?tipo=' . $tipo . '"><i class="bi-clipboard-plus"></i> Novo ' . (($tipo == "1") ? 'Pagamento' : 'Recebimento') . '</a>' : '') ?> </td>
                        </tr>
                        </table>                     
                        
                        <div class="card mb-4">
                            <div class="card-header">
                                <table width="100%">
                                <form id="pesquisa_pagamentos_recebimentos" name="pesquisa_pagamentos_recebimentos" action="pagamentos_recebimentos.php" method="get">
                                <tr>
                                <td nowrap><i class="bi-people-fill"></i> <?= ($tipo == "1") ? 'Pagamentos' : 'Recebimentos' ?> Cadastrados | <span><a id="exibir_filtro_datas_span" href="javascript:exibir_filtro_datas()">Ocultar Filtro</a></span></td>
                                
                                <td nowrap align="right">
                                
                                <div style="width:230px" class="input-group">
    
    <a title="Opçoes" class="nav-link dropdown-toggle" id="navbarDropdown" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
    <i class="bi bi-markdown"></i>
  </a>
  <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
    <li><a class="dropdown-item" href="javascript:definir_paginacao()">Pagina&ccedil;&atilde;o e Ordena&ccedil;&atilde;o</a></li>
    <li><a class="dropdown-item" href="pagamentos_recebimentos.php?tipo=<?= $tipo ?>">Limpar Pesquisa e Filtro</a></li>
  </ul>
    <input type="text" name="pesquisa" id="pesquisa" <?= (isset($_GET["pesquisa"]) ? ' value="' . $pesquisa_pagamentos_recebimentos . '"' : '') ?> required class="form-control" placeholder="Pesquisar">
    <input type="hidden" name="tipo" id="tipo" value="<?= $tipo ?>"/>
    <div class="input-group-append">
      <button class="btn btn-secondary" type="submit">
        <i class="fa fa-search"></i>
      </button>
    </div>
  </div>
                                
                                </td>
                                </tr>
                                </form>
                                </table>
                                
                            </div>
                            
                            <div class="card-body">
                            
                            <form action="pagamentos_recebimentos.php" method="get" name="form_filtro">
                            
                            <div id="filtro_datas" class="row">
                               <div class="col-xl-4">
                                  <div class="card mb-4">
                                     <div class="card-body">
                                    
                                      
                                      <div class="row justify-content-between text-left">
                                       <div class="form-group col-sm-6 flex-column d-flex">
                                         <label style="padding-left: 5px" class="form-control-label">Data Inicial<span class="text-danger"> *</span></label>
                                         <input type="text" style="margin-bottom: 10px; margin-top: 10px" required class="form-control" value="<?= $data_inicial_str ?>" name="data_inicial" id="data_inicial" placeholder="Escolha a data">
                                       </div>
                                    
                                       <div class="form-group col-sm-6 flex-column d-flex">
                                         <label style="padding-left: 5px" class="form-control-label">Data Final<span class="text-danger"> *</span></label>
                                         <input type="text" style="margin-bottom: 10px; margin-top: 10px" required class="form-control" value="<?= $data_final_str ?>" name="data_final" id="data_final" placeholder="Escolha a data">
                                       </div>
                                       
                                       <div style="padding-left: 10px; padding-top: 0px"><hr/></div>
                                       
                                       <div style="padding-top: 0px; padding-left: 12px; padding-right: 10px">
                                         <button type="submit" name="btn_filtro" id="btn_filtro" class="btn-block btn-secondary">Aplicar Filtro</button>
                                         <input type="hidden" name="tipo" id="tipo" value="<?= $tipo ?>"/>
                                       </div>
                                    </div>
                                          
                                     
                                    
                                     </div>
                                  </div>
                               
                               
                               </div>
                               
                               <div class="col-xl-8">
                                   <div class="card mb-4">
                                      <div class="card-body">
                                         
                                         <div class="row justify-content-between text-left">
                                       <div class="form-group col-12 flex-column d-flex">
                                       <label style="padding-left: 5px" class="form-control-label">Plano de Contas<span class="text-danger"> *</span></label>
                                          <select name="plano" id="plano" style="margin-bottom: 10px; margin-top: 10px" class="form-select">
                                             <option selected value="-1">TODOS</option>
											 <?php
											   $result = mysqli_query($conexao, "SELECT id, nome from plano_contas WHERE id_tipo_conta = '$tipo'");
                                               if($result){
	                                              while($detalhes = mysqli_fetch_array($result)){
	                                                 $id_plano_conta = utf8_encode($detalhes["id"]);
	                                                 $nome_plano_conta = utf8_encode($detalhes["nome"]);
													 if($id_plano_conta == $plano){
													   echo '<option selected value="' . $id_plano_conta . '">' . $nome_plano_conta . '</option>';
													 }
													 else{
													   echo '<option value="' . $id_plano_conta . '">' . $nome_plano_conta . '</option>'; 	 
													 }
												  }
											   }
											 ?>
                                          </select>
                                       </div>
                                    </div>
                                    
                                    <div class="row justify-content-between text-left">
                                       <div class="form-group col-12 flex-column d-flex">
                                       <label style="padding-left: 5px" class="form-control-label">Forma de <?= ($tipo == "1") ? 'Pagamento' : 'Recebimento' ?><span class="text-danger"> *</span></label>
                                          <select name="forma_pagamento_recebimento" id="forma_pagamento_recebimento" style="margin-bottom: 10px; margin-top: 10px" class="form-select">
                                             <option selected value="-1">TODAS</option>
											 <?php
											   $result = mysqli_query($conexao, "SELECT id, nome from formas_pagamento_recebimento WHERE tipo = '$tipo'");
                                               if($result){
	                                              while($detalhes = mysqli_fetch_array($result)){
	                                                 $id_forma_pagamento_recebimento = utf8_encode($detalhes["id"]);
	                                                 $nome_forma_pagamento_recebimento = utf8_encode($detalhes["nome"]);
													 
													 if($id_forma_pagamento_recebimento == $forma){
													   echo '<option selected value="' . $id_forma_pagamento_recebimento . '">' . $nome_forma_pagamento_recebimento 
													      . '</option>';
													 }
													 else{
													    echo '<option value="' . $id_forma_pagamento_recebimento . '">' . $nome_forma_pagamento_recebimento 
													      . '</option>'; 	 
													 }
												  }
											   }
											 ?>
                                          </select>
                                       </div>
                                    </div>
                                         
                                      </div>
                                   </div>
                               </div>
                               
                            </div>    
                            </form>
                            
							<?php
					   if($num_rows2 == 0){
						   echo '<b>Nenhum registro encontrado nesta pesquisa.</b>';
					   }
					   else{
						   echo '<b>' . $num_rows2 . '</b> registros encontrados. Página <b>' . $page . '</b> de 
						      <b>' . ceil($num_rows2 / $pagesize) . '</b>';
					   }
					   
					?>
                    
                    
                    <div style="padding-top: 15px" class="table-responsive">
                    <table class="table">
                       <thead>
                         <tr style="color: #455a64; background-color: #f5f5f5">
                            <th>Ord</th>
                            <th>Data</th>
                            <th>Descri&ccedil;&atilde;o</th>
                            <th>Cliente/Fornecedor</th>
                            <th>Valor</th>
                            <th>Op&ccedil;&otilde;es</th>
                            <th>Data Cadastro</th>
                            <th>Usu&aacute;rio</th>
                         </tr>
                       </thead>
                       <tbody>
					   
					   <?php
                         $ordem = 0;
						 $total_pagina = 0;
                         if($resultado_paginacao){
                            while($detalhes = mysqli_fetch_array($resultado_paginacao)){
                               $ordem++;
					           $id = $detalhes["id"];
							   $id_cliente_fornecedor = $detalhes["id_cliente_fornecedor"];
							   $descricao = nl2br(utf8_encode($detalhes["descricao"]));
							   $valor = $detalhes["valor"];
							   $acrescimo = $detalhes["acrescimo"];
	                           $abatimento = $detalhes["abatimento"];
	                           $valor_total = ($valor + $acrescimo) - $abatimento;
							   $total_pagina = $total_pagina + $valor_total;
							   $data_cadastro = $detalhes["data_cadastro_lanc"];
							   $data = $detalhes["data"];
							   $usuario_cadastro = $detalhes["usuario_cadastro"]; 
							   $dados_cliente_fornecedor = obterNomeFantasiaId($id_cliente_fornecedor);
							
							   $possui_anexo = '';
							   $result_anexo = mysqli_query($conexao, "select id from anexos_pagamentos_recebimentos WHERE tipo = '$tipo'
								  and id_pai = '$id'");
     					       $quant_anexos = mysqli_num_rows($result_anexo);
							   if($quant_anexos > 0){
								  $possui_anexo = ' <i class="fas fa-paperclip"></i> '; 
							   }
							
							   if($ordem % 2 == 0){
							      echo '<tr style="background-color: ghostwhite">';
							   }
							   else{
							      echo '<tr style="background-color: white">';	
							   }
							   
							   echo '<td style="vertical-align: top" nowrap="nowrap" align="left">' . $ordem . '</td>';
							   echo '<td style="vertical-align: top" nowrap="nowrap" align="left">' . $data . $possui_anexo . '</td>';
							   echo '<td valign="top" width="80%">' . $descricao . '</td>';
							   
							   if($id_cliente_fornecedor == "0"){
								  echo '<td valign="top">' . $dados_cliente_fornecedor[0] . '</td>'; 
							   }
							   else{
							     if($dados_cliente_fornecedor[1] == "2"){
								    echo '<td valign="top"><a href="cliente_fornecedor.php?aba_clientes=show&tipo=2&cliente_fornecedor=' . $id_cliente_fornecedor . '">' . $dados_cliente_fornecedor[0] . '</a></td>'; 
							     }
							     else{
								    echo '<td valign="top"><a href="cliente_fornecedor.php?aba_clientes=show&tipo=1&cliente_fornecedor=' . $id_cliente_fornecedor . '">' . $dados_cliente_fornecedor[0] . '</a></td>';   
							     }
							   }
							   
							   echo '<td valign="top" align="right">' . number_format($valor_total, 2, ',', '.') . '</td>';
							   
							   echo '<td style="vertical-align: top" nowrap align="left">';
							   echo '<a title="Clique para mais detalhes" href="pagamento_recebimento.php?tipo=' . $tipo . '&pagamento_recebimento=' . $id . '"><img style="display: inline" border="0" width="30px" src="imagens/detalhes.png"/></a> '; 
							   if(Permissao::podeExcluir($_SESSION["nivel_acesso"])){
								  echo '<a title="Clique para excluir" href="javascript:excluir_registro(' . $id . ', \'' . 
									 $descricao . '\')"><img border="0" width="30px" src="imagens/excluir.gif"/></a> ';  
							   }
							   echo '</td>';
							   
							   echo '<td style="vertical-align: top" nowrap="nowrap" align="left">' . $data_cadastro . '</td>';
							   echo '<td style="vertical-align: top" nowrap="nowrap" align="center">' . obterNomeUsuarioId($usuario_cadastro) . '</td>';
							   
							echo '</tr>';
							}
			              }
						  
					   ?>
                       
                       </tbody>
                       <tfoot>
                         <tr style="color: #455a64; background-color: #f5f5f5">
                            <th style="text-align: right" colspan="8"><span style="font-weight: normal">Total nesta p&aacute;gina:</span> <span>R$ <?= number_format($total_pagina, 2, ',', '.') ?></span></th>
                         </tr>
                       </tfoot>  
                    </table>
                  </div>
                    
                    <!-- Pagination -->
            <div style="margin-top: 10px">
            <ul class="pagination justify-content-center">
                <?php
				  // opoes de filtro e ordenaao
				  // ?data_inicial=2021-01-04&data_final=2021-12-20
				  
				    $pagina_atual = 'pagamentos_recebimentos.php';
                    if((isset($_GET["ordem_por"])) && (isset($_GET["pesquisa"]))){
	                   $link_paginacao = $pagina_atual . '?data_inicial=' . $data_inicial . '&data_final=' . $data_final . '&plano=' . $plano . '&forma_pagamento_recebimento=' . $forma . '&tipo=' . $tipo . '&pesquisa=' . $_GET["pesquisa"] . '&ordem_class=' . $_GET["ordem_class"] 
					     . '&quant_paginas=' . $_GET["quant_paginas"] . '&ordem_por=' . $_GET["ordem_por"] . '&';  
                    }
                    else if((isset($_GET["ordem_por"])) && (!isset($_GET["pesquisa"]))){
	                   $link_paginacao = $pagina_atual . '?data_inicial=' . $data_inicial . '&data_final=' . $data_final . '&plano=' . $plano . '&forma_pagamento_recebimento=' . $forma . '&tipo=' . $tipo . '&ordem_class=' . $_GET["ordem_class"] . '&quant_paginas=' 
					     . $_GET["quant_paginas"] . '&ordem_por=' . $_GET["ordem_por"] . '&';  
                    }
                    else if((!isset($_GET["ordem_por"])) && (isset($_GET["pesquisa"]))){
	                   $link_paginacao = $pagina_atual . '?data_inicial=' . $data_inicial . '&data_final=' . $data_final . '&plano=' . $plano . '&forma_pagamento_recebimento=' . $forma . '&tipo=' . $tipo . '&pesquisa=' . $_GET["pesquisa"] . '&';  
                    }
                    else{
					   $link_paginacao = $pagina_atual . '?data_inicial=' . $data_inicial . '&data_final=' . $data_final . '&plano=' . $plano . '&forma_pagamento_recebimento=' . $forma . '&tipo=' . $tipo;
					}
				?>
                <li class="page-item <?php if($page <= 1){ echo 'disabled'; } ?>">
                    <a class="page-link"
                        href="<?php if($page <= 1){ echo $link_paginacao . 'page=1'; } else { echo $link_paginacao . "page=" . $prev_page; } ?>"><<</a>
                </li>

                <?php for($i = 1; $i <= $totoalPages; $i++ ): ?>
                <li class="page-item <?php if($page == $i) {echo 'active'; } ?>">
                
                    <?php
                      echo '<a class="page-link" href="' . $link_paginacao . 'page=' . $i . '"> ' . $i . ' </a>';
                    ?> 
                </li>
                <?php endfor; ?>

                <li class="page-item <?php if($page >= $totoalPages) { echo 'disabled'; } ?>">
                    <a class="page-link"
                        href="<?php if($page >= $totoalPages){ echo $link_paginacao . 'page=1'; } else {echo $link_paginacao . "page=". $next_page; } ?>">>></a>
                </li>
            </ul> 
            
            
                            <?php
							  $este_ano = date("Y");
							  $link_este_ano = 'pagamentos_recebimentos.php?data_inicial=' . $este_ano . '-01-01&data_final=' . 
							    $este_ano . '-12-31&tipo=' . $tipo;
							  
							  $ano_passado = ($este_ano - 1);
							  $link_ano_passado = 'pagamentos_recebimentos.php?data_inicial=' . $ano_passado . '-01-01&data_final=' . 
							    $ano_passado . '-12-31&tipo=' . $tipo;
							  
							  $este_mes = mktime(0, 0, 0, date("m"), date("d"), date("Y"));
							  $link_este_mes = 'pagamentos_recebimentos.php?data_inicial=' . date("Y", $este_mes) . '-' . 
							    date("m", $este_mes) . '-01&data_final=' . date("Y", $este_mes) . '-' . 
							    date("m", $este_mes) . '-' . cal_days_in_month(CAL_GREGORIAN, (int)(date("m", $este_mes)), 
								(int)(date("Y", $este_mes))) . '&tipo=' . $tipo;
							  $este_mes = date("m/Y", $este_mes);
							  
							  $mes_passado = mktime(0, 0, 0, date("m") - 1, date("d"), date("Y"));
							  $link_mes_passado = 'pagamentos_recebimentos.php?data_inicial=' . date("Y", $mes_passado) . '-' . 
							    date("m", $mes_passado) . '-01&data_final=' . date("Y", $mes_passado) . '-' . 
							    date("m", $mes_passado) . '-' . cal_days_in_month(CAL_GREGORIAN, (int)(date("m", $mes_passado)), 
								(int)(date("Y", $mes_passado))) . '&tipo=' . $tipo;
							  $mes_passado = date("m/Y", $mes_passado);
							  
							  $hoje = mktime(0, 0, 0, date("m"), date("d"), date("Y")); // hoje 
                              $hoje_temp = date("Y-m-d", $hoje);
							  $hoje = date("d/m/Y", $hoje);
							  $link_hoje = 'pagamentos_recebimentos.php?data_inicial=' . $hoje_temp . '&data_final=' . 
							    $hoje_temp . '&tipo=' . $tipo;
							  
							  $ontem = mktime(0, 0, 0, date("m"), date("d") - 1, date("Y")); // hoje 
                              $ontem_temp = date("Y-m-d", $ontem);
							  $ontem = date("d/m/Y", $ontem);
							  $link_ontem = 'pagamentos_recebimentos.php?data_inicial=' . $ontem_temp . '&data_final=' . 
							    $ontem_temp . '&tipo=' . $tipo;
							  
							  $result_es = mysqli_query($conexao, "SELECT id FROM pagamentos_recebimentos WHERE tipo = '$tipo'");
                              $quant_lancamentos = mysqli_num_rows($result_es);
							  
							  $result_es = mysqli_query($conexao, "SELECT id FROM pagamentos_recebimentos WHERE tipo = '$tipo' AND YEAR(data_pagamento_recebimento) = '$este_ano'");
                              $quant_lancamentos_este_ano = mysqli_num_rows($result_es);
							  
							  $result_es = mysqli_query($conexao, "SELECT id FROM pagamentos_recebimentos WHERE tipo = '$tipo' AND YEAR(data_pagamento_recebimento) = '$ano_passado'");
                              $quant_lancamentos_ano_passado = mysqli_num_rows($result_es);
							  
							  $result_es = mysqli_query($conexao, "SELECT id FROM pagamentos_recebimentos WHERE tipo = '$tipo' AND 
							    DATE_FORMAT(data_pagamento_recebimento, '%m/%Y') = '$mes_passado'");
                              $quant_lancamentos_mes_passado = mysqli_num_rows($result_es);
							  
							  $result_es = mysqli_query($conexao, "SELECT id FROM pagamentos_recebimentos WHERE tipo = '$tipo' AND 
							    DATE_FORMAT(data_pagamento_recebimento, '%m/%Y') = '$este_mes'");
                              $quant_lancamentos_este_mes = mysqli_num_rows($result_es);
							  
							  $result_es = mysqli_query($conexao, "SELECT id FROM pagamentos_recebimentos WHERE tipo = '$tipo' AND 
							    DATE_FORMAT(data_pagamento_recebimento, '%d/%m/%Y') = '$ontem'");
                              $quant_lancamentos_ontem = mysqli_num_rows($result_es);
							  
							  $result_es = mysqli_query($conexao, "SELECT id FROM pagamentos_recebimentos WHERE tipo = '$tipo' AND 
							    DATE_FORMAT(data_pagamento_recebimento, '%d/%m/%Y') = '$hoje'");
                              $quant_lancamentos_hoje = mysqli_num_rows($result_es);
							  
							  echo '<div style="margin-bottom: 10px; color: #546e7a"><span style="font-size: 130%"><i class="bi-lightbulb"></i> Estat&iacute;sticas:</span><br>No total h&aacute; <b>' . $quant_lancamentos . '</b> lan&ccedil;amentos de ' . (($tipo == "1") ? 'pagamentos' : 'recebimentos') . ' no sistema.</div>';
							  
							  echo '<div class="row">';
							    echo '<div class="col-xl-4">';
							       echo '<div style="font-size: 300%"><b>' . $quant_lancamentos_ano_passado . '</b></div><div style="border-top: 1px solid #bdbdbd">no <a href="' . $link_ano_passado . '">ano passado</a> (' . $ano_passado . ').</div>';  
                                echo '</div>';
							    
								echo '<div class="col-xl-4">';
							       echo '<div style="font-size: 300%"><b>' . $quant_lancamentos_este_ano . '</b></div><div style="border-top: 1px solid #bdbdbd"><a href="' . $link_este_ano . '">neste ano</a> (' . $este_ano . ').</div>';  
                                echo '</div>';
							  
							    echo '<div class="col-xl-4">';
							       echo '<div style="font-size: 300%"><b>' . $quant_lancamentos_mes_passado . '</b></div><div style="border-top: 1px solid #bdbdbd">no <a href="' . $link_mes_passado . '">m&ecirc;s passado</a> (' . $mes_passado . ').</div>';  
                                echo '</div>';
								
								echo '<div class="col-xl-4">';
							       echo '<div style="font-size: 300%"><b>' . $quant_lancamentos_este_mes . '</b></div><div style="border-top: 1px solid #bdbdbd"><a href="' . $link_este_mes . '">neste m&ecirc;s</a> (' . $este_mes . ').</div>';  
                                echo '</div>';
							  
							    echo '<div class="col-xl-4">';
							       echo '<div style="font-size: 300%"><b>' . $quant_lancamentos_ontem . '</b></div><div style="border-top: 1px solid #bdbdbd"><a href="' . $link_ontem . '">ontem</a> (' . $ontem . ').</div>';  
                                echo '</div>';
								
								echo '<div class="col-xl-4">';
							       echo '<div style="font-size: 300%"><b>' . $quant_lancamentos_hoje . '</b></div><div style="border-top: 1px solid #bdbdbd"><a href="' . $link_hoje . '">hoje</a> (' . $hoje . ').</div>';  
                                echo '</div>';
							echo '</div>';
							?>
            
                            
                            </div>
                        </div>
                        
                        
                        <div id="janela_excluir_lancamento" class="modal fade" role="dialog" style="width:100%">
    <div class="modal-dialog" style="width: 60%;">
        <div class="modal-content" >
            <div class="modal-header">Excluir</div>
            <div class="modal-body"><span id="msg_excluir"></span></div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" onclick="confirmar_exclusao()">Confirmar</button>
                <button type="button" class="btn btn-secondary" onclick="fechar_exclusao()" data-dismiss="modal">Cancelar</button>
            </div>
        </div>
    </div>
    </div>
          
          
          <div id="janela_paginacao" class="modal fade" role="dialog" style="width:100%">
            <form name="form_paginacao" action="pagamentos_recebimentos.php" method="get" id="form_paginacao">
            <div class="modal-dialog" style="width: 60%;">
               <div class="modal-content" >
                 <div class="modal-header">Pagina&ccedil;&atilde;o e Ordena&ccedil;&atilde;o</div>
                 <div class="modal-body">
                 
                 <div class="mb-3">
                   <label for="quant_paginas" class="form-label">Quantidade por P&aacute;gina</label>
                   <select class="form-select" id="quant_paginas" name="quant_paginas">
                      
                      <?php
					    for($i = 0; $i < count($opcoes_paginacao); $i++){
						   echo '<option value="' . $opcoes_paginacao[$i] . '">' . $opcoes_paginacao[$i] . ' itens por p&aacute;gina</option>';	
						}
					  ?>
                      
                   </select>
                 </div>
                 
                 <div class="mb-3">
                   <label for="ordem_por" class="form-label">Ordenar por</label>
                   <select class="form-select" id="ordem_por" name="ordem_por">
                      
                      <?php
					    $nomes_campos = array('id', 'valor', 'data_pagamento_recebimento', 'descricao', 'data_cadastro');
						$titulos_campos = array('C&oacute;digo', 'Valor', 'Data Pagamento/Recebimento', 'Descri&ccedil;&atilde;o', 'Data de Cadastro');
						
						for($i = 0; $i < count($nomes_campos); $i++){
						   echo '<option value="' . $nomes_campos[$i] . '">' . $titulos_campos[$i] . '</option>';	
						}	
					  ?>
                      
                   </select>
                 </div>
                 
                 <div class="mb-3">
                   <label for="ordem_class" class="form-label">Ordem de Classifica&ccedil;&atilde;o</label>
                   <select class="form-select" id="ordem_class" name="ordem_class">
                      
                      <?php
					    echo '<option value="asc">Ascendente</option>';
						echo '<option value="desc">Descendente</option>';	
					  ?>
                      
                   </select>
                 </div>
                 
                 </div>
                 <div class="modal-footer">
                    <button type="button" onClick="document.form_paginacao.submit()" class="btn btn-secondary">Confirmar</button>
                    <button type="button" class="btn btn-secondary" onclick="fechar_paginacao()" data-dismiss="modal">Cancelar</button>
                    <input type="hidden" name="tipo" id="tipo" value="<?= $tipo ?>"/>
                    <input type="hidden" name="data_inicial" id="data_inicial" value="<?= $data_inicial ?>">
                    <input type="hidden" name="data_final" id="data_final" value="<?= $data_final ?>">
                    <input type="hidden" name="plano" id="plano" value="<?= $plano ?>">
                    <input type="hidden" name="forma_pagamento_recebimento" id="forma_pagamento_recebimento" value="<?= $forma ?>">  
                    
                    <?php
					  if(isset($_GET["pesquisa"])){
						echo '<input type="hidden" value="' . $_GET["pesquisa"] . '" id="pesquisa" name="pesquisa">';  
					  }
					?>
                 </div>
               </div>
            </div>
            </form>
          </div>
                        
                        
                    </div>
                </main>
                
                <?php require("rodape.php"); ?>
                
            </div>
        </div>
        <script src="bootstrap-5.0.2/js/bootstrap.bundle.min.js" crossorigin="anonymous"></script>
        <script src="js/scripts.js"></script>
    
    <script type="text/javascript">
	   var $modalPaginacao = $('#janela_paginacao');
	   var $modal = $('#janela_excluir_lancamento');
	   var id_exlusao = 0;
	   var descricao_lancamento_excluir;
	   
	   function excluir_registro(id, nome){
		 id_exclusao = id;
		 descricao_lancamento_excluir = nome;
		 $('#msg_excluir').html("Voce deseja mesmo excluir o lancamento <b>" + nome + "</b>?<br><br>Esta operacao nao podera ser desfeita.");
		 $modal.modal('show');    
	   }
	   
	   function confirmar_exclusao(){
		 var url_volta = window.location.href.replaceAll("&", "@@");
		 window.location = "excluir_pagamento_recebimento.php?pagamento_recebimento=" + id_exclusao + "&descricao_lancamento_excluir=" + descricao_lancamento_excluir + "&volta=" + url_volta;    
	   }
	   
	   function fechar_exclusao(){
	     $modal.modal('hide');
       }
	   
	   function definir_paginacao(){
		 $modalPaginacao.modal('show');    
	   }
	   
	   function fechar_paginacao(){
	     $modalPaginacao.modal('hide');
       }
	</script>
    
        <script src="js/popper.min.js"></script>
        <script src="js/picker.js"></script>
        <script src="js/picker.date.js"></script>
        
        <script type="text/javascript">
		  $(function() {
             $('#data_inicial').pickadate({
			    today: 'Hoje',
                clear: 'Limpar',
                close: 'Cancelar',
				weekdaysShort: ['D', 'S', 'T', 'Q', 'Q', 'S', 'S'],
                showMonthsShort: true,
				format: 'dd/mm/yyyy',
				formatSubmit: 'yyyy-mm-dd',
                hiddenName: true,
				labelMonthNext: 'Pr&oacute;ximo M&ecirc;s',
                labelMonthPrev: 'M&ecirc;s Anterior',
                labelMonthSelect: 'Selecione o M&ecirc;s',
                labelYearSelect: 'Selecione um Ano',
				monthsFull: ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'],
                monthsShort: ['Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set', 'Out', 'Nov', 'Dez'],
                weekdaysFull: ['Domingo', 'Segunda', 'Ter&ccedil;a', 'Quarta', 'Quinta', 'Sexta', 'S&aacute;bado'] 
			 });
			 
			 $('#data_final').pickadate({
			    today: 'Hoje',
                clear: 'Limpar',
                close: 'Cancelar',
				weekdaysShort: ['D', 'S', 'T', 'Q', 'Q', 'S', 'S'],
                showMonthsShort: true,
				format: 'dd/mm/yyyy',
				formatSubmit: 'yyyy-mm-dd',
                hiddenName: true,
				labelMonthNext: 'Pr&oacute;ximo M&ecirc;s',
                labelMonthPrev: 'M&ecirc;s Anterior',
                labelMonthSelect: 'Selecione o M&ecirc;s',
                labelYearSelect: 'Selecione um Ano',
				monthsFull: ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'],
                monthsShort: ['Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set', 'Out', 'Nov', 'Dez'],
                weekdaysFull: ['Domingo', 'Segunda', 'Ter&ccedil;a', 'Quarta', 'Quinta', 'Sexta', 'S&aacute;bado'] 
			 });
          });
    </script>
	
    <script type="text/javascript">
	   function exibir_filtro_datas(){
		 if($('#filtro_datas').is(":visible")){
			$('#filtro_datas').hide();
			$('#exibir_filtro_datas_span').text('Exibir Filtro'); 
		 }
		 else{
		    $('#filtro_datas').show();
			$('#exibir_filtro_datas_span').text('Ocultar Filtro');
		 }
	   }
	</script>
    
    </body>
</html>

